package ru.yandex.search.yc.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractStaleDocsConfigBuilder
    <T extends AbstractStaleDocsConfigBuilder<T>>
     implements StaleDocsConfig
{
    private boolean markEnabled;
    private long timePassedSinceLastReindexThreshold;
    private long markStaleThreshold;
    private long suspiciousStaleMinThreshold;
    private long suspiciousStaleMaxThreshold;

    public AbstractStaleDocsConfigBuilder(final StaleDocsConfig config) {
        markEnabled(config.markEnabled());
        timePassedSinceLastReindexThreshold(
            config.timePassedSinceLastReindexThreshold());
        markStaleThreshold(config.markStaleThreshold());
        suspiciousStaleMinThreshold(config.suspiciousStaleMinThreshold());
        suspiciousStaleMaxThreshold(config.suspiciousStaleMaxThreshold());
    }

    public AbstractStaleDocsConfigBuilder(
        final IniConfig config,
        final StaleDocsConfig defaults)
        throws ConfigException
    {
        this.markEnabled =
            config.getBoolean("mark-enabled", defaults.markEnabled());
        this.timePassedSinceLastReindexThreshold =
            config.getLongDuration(
                "time-passed-since-last-reindex-threshold",
                defaults.timePassedSinceLastReindexThreshold());
        this.markStaleThreshold =
            config.getLongDuration(
                "mark-stale-threshold",
                defaults.markStaleThreshold());
        this.suspiciousStaleMinThreshold =
            config.getLongDuration(
                "suspicious-stale-min-threshold",
                defaults.suspiciousStaleMinThreshold());
        this.suspiciousStaleMaxThreshold =
            config.getLongDuration(
                "suspicious-stale-max-threshold",
                defaults.suspiciousStaleMaxThreshold());
    }

    @Override()
    public boolean markEnabled() {
        return markEnabled;
    }

    public T markEnabled(final boolean value) {
        this.markEnabled = value;
        return self();
    }

    @Override()
    public long timePassedSinceLastReindexThreshold() {
        return timePassedSinceLastReindexThreshold;
    }

    public T timePassedSinceLastReindexThreshold(final long value) {
        this.timePassedSinceLastReindexThreshold = value;
        return self();
    }

    @Override()
    public long markStaleThreshold() {
        return markStaleThreshold;
    }

    public T markStaleThreshold(final long value) {
        this.markStaleThreshold = value;
        return self();
    }

    @Override()
    public long suspiciousStaleMinThreshold() {
        return suspiciousStaleMinThreshold;
    }

    public T suspiciousStaleMinThreshold(final long value) {
        this.suspiciousStaleMinThreshold = value;
        return self();
    }

    @Override()
    public long suspiciousStaleMaxThreshold() {
        return suspiciousStaleMaxThreshold;
    }

    public T suspiciousStaleMaxThreshold(final long value) {
        this.suspiciousStaleMaxThreshold = value;
        return self();
    }

    protected abstract T self();
}
