package ru.yandex.search.yc.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableFieldGroupingElementStatersConfig
     extends ImmutableHttpTargetConfig
     implements FieldGroupingElementStatersConfig
{
    private final Map<String, ImmutableFieldGroupingElementStaterConfig> serviceStats;
    private final ImmutableStaleDocsConfig staleConfig;
    private final int interval;
    private final HttpHost host;

    public ImmutableFieldGroupingElementStatersConfig(
        final FieldGroupingElementStatersConfig config)
        throws ConfigException
    {
        super(config);
        Map<String, ImmutableFieldGroupingElementStaterConfig> map = new LinkedHashMap<>();
        for (Map.Entry<String, ? extends FieldGroupingElementStaterConfig> entry: config.fieldGroupingElementStats().entrySet()) {
            map.put(entry.getKey(), new FieldGroupingElementStaterConfigBuilder(entry.getValue()).build());
        }

        this.serviceStats = Collections.unmodifiableMap(map);
        this.staleConfig = new ImmutableStaleDocsConfig(config.staleConfig());
        this.interval = config.interval();
        if (config.host() == null) {
            throw new ConfigException("Host is not specified");
        }
        this.host = config.host();
    }

    @Override
    public Map<String, ImmutableFieldGroupingElementStaterConfig> fieldGroupingElementStats() {
        return serviceStats;
    }

    @Override
    public int interval() {
        return interval;
    }

    @Override
    public ImmutableStaleDocsConfig staleConfig() {
        return staleConfig;
    }

    @Override
    public HttpHost host() { return host; }
}
