package ru.yandex.search.yc.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableStaleDocsConfig
     implements StaleDocsConfig
{
    private final boolean markEnabled;
    private final long timePassedSinceLastReindexThreshold;
    private final long markStaleThreshold;
    private final long suspiciousStaleMinThreshold;
    private final long suspiciousStaleMaxThreshold;

    public ImmutableStaleDocsConfig(
        final StaleDocsConfig config)
        throws ConfigException
    {
        this.markEnabled = config.markEnabled();
        this.timePassedSinceLastReindexThreshold =
            config.timePassedSinceLastReindexThreshold();
        this.markStaleThreshold = config.markStaleThreshold();
        this.suspiciousStaleMinThreshold = config.suspiciousStaleMinThreshold();
        this.suspiciousStaleMaxThreshold = config.suspiciousStaleMaxThreshold();
    }

    @Override
    public boolean markEnabled() {
        return markEnabled;
    }

    @Override
    public long timePassedSinceLastReindexThreshold() {
        return timePassedSinceLastReindexThreshold;
    }

    @Override
    public long markStaleThreshold() {
        return markStaleThreshold;
    }

    @Override
    public long suspiciousStaleMinThreshold() {
        return suspiciousStaleMinThreshold;
    }

    @Override
    public long suspiciousStaleMaxThreshold() {
        return suspiciousStaleMaxThreshold;
    }
}
