package ru.yandex.search.yc.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.client.producer.ProducerClientConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;
import ru.yandex.search.yc.BadIndexMessageAction;
import ru.yandex.search.yc.IndexationTargetFactory;
import ru.yandex.search.yc.schema.YcSearchIndexDocParser;

public class ImmutableYcSearchIndexerConfig
     extends ImmutableUniversalSearchProxyConfig
     implements YcSearchIndexerConfig
{
    private final BadIndexMessageAction badIndexMessageAction;
    private final String malformedDocsService;
    private final IndexationTargetFactory indexationTarget;
    private final Map<String, YcSearchIndexDocParser> schemas;
    private final ProducerClientConfig marketProducerClientConfig;
    private final ImmutableFieldGroupingElementStatersConfig serviceStatConfig;
    private final ImmutableFieldGroupingElementStatersConfig marketStatConfig;

    public ImmutableYcSearchIndexerConfig(
        final YcSearchIndexerConfig config)
        throws ConfigException
    {
        super(config);

        this.badIndexMessageAction = config.badIndexMessageAction();
        this.malformedDocsService = config.malformedDocsService();
        this.schemas = Collections.unmodifiableMap(new LinkedHashMap<>(config.schemas()));
        this.indexationTarget = config.indexationTarget();
        if (badIndexMessageAction == BadIndexMessageAction.SAVE_IN_INDEX && malformedDocsService == null) {
            throw new ConfigException("Malformed docs service should be not empty if SAVE_IN_INDEX was chosen");
        }
//        marketProducerClientConfig = new ImmutableProducerClientConfig(
//                config.marketProducerClientConfig());
        marketProducerClientConfig = config.marketProducerClientConfig();
        serviceStatConfig = new ImmutableFieldGroupingElementStatersConfig(config.serviceStatConfig());
        marketStatConfig = new ImmutableFieldGroupingElementStatersConfig(config.marketStatConfig());
    }

    @Override
    public BadIndexMessageAction badIndexMessageAction() {
        return badIndexMessageAction;
    }

    @Override
    public String malformedDocsService() {
        return malformedDocsService;
    }

    @Override
    public Map<String, YcSearchIndexDocParser> schemas() {
        return schemas;
    }

    @Override
    public IndexationTargetFactory indexationTarget() {
        return indexationTarget;
    }

    @Override
    public ProducerClientConfig marketProducerClientConfig() {
        return marketProducerClientConfig;
    }

    @Override
    public ImmutableFieldGroupingElementStatersConfig serviceStatConfig() {
        return serviceStatConfig;
    }

    @Override
    public ImmutableFieldGroupingElementStatersConfig marketStatConfig() {
        return marketStatConfig;
    }
}
