package ru.yandex.search.yc.config;

public interface StaleDocsConfig {
    boolean markEnabled();
    /**
     * Threshold for service, number of days from last reindex that we tolerate
     * and keep marking stale docs for service
     * @return
     */
    long timePassedSinceLastReindexThreshold();

    /**
     * Threshold for document to be marked stale, (last_service_reindex_ts - current_doc_reindex_ts) > markStaleThreshold
     * @return
     */
    long markStaleThreshold();

    /**
     *  Threshold for marking doc suspicious to be stale
     *  suspiciousStaleMaxThreshold > (last_service_reindex_ts - current_doc_reindex_ts) > suspiciousStaleMinThreshold
     */
    long suspiciousStaleMinThreshold();

    /**
     *  Threshold for marking doc suspicious to be stale
     *  suspiciousStaleMaxThreshold > (last_service_reindex_ts - current_doc_reindex_ts) > suspiciousStaleMinThreshold
     */
    long suspiciousStaleMaxThreshold();
}
