package ru.yandex.search.yc.config;

import java.util.concurrent.TimeUnit;

public class StaleDocsConfigDefaults
     implements StaleDocsConfig
{
    public static final StaleDocsConfigDefaults INSTANCE =
        new StaleDocsConfigDefaults();

    protected StaleDocsConfigDefaults() {
    }

    @Override
    public boolean markEnabled() {
        return true;
    }

    @Override
    public long timePassedSinceLastReindexThreshold() {
        return TimeUnit.DAYS.toMillis(14);
    }

    @Override
    public long markStaleThreshold() {
        return TimeUnit.DAYS.toMillis(2);
    }

    @Override
    public long suspiciousStaleMinThreshold() {
        return TimeUnit.DAYS.toMillis(2);
    }

    @Override
    public long suspiciousStaleMaxThreshold() {
        return TimeUnit.DAYS.toMillis(1) + TimeUnit.HOURS.toMillis(1);
    }
}
