package ru.yandex.search.yc.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class YcSearchIndexerConfigBuilder
     extends AbstractYcSearchIndexerConfigBuilder<YcSearchIndexerConfigBuilder>
{
    public YcSearchIndexerConfigBuilder() {
        this(YcSearchIndexerConfigDefaults.INSTANCE);
    }

    public YcSearchIndexerConfigBuilder(final YcSearchIndexerConfig config) {
        super(config);
    }

    public YcSearchIndexerConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, YcSearchIndexerConfigDefaults.INSTANCE);
    }

    public YcSearchIndexerConfigBuilder(
        final IniConfig config,
        final YcSearchIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableYcSearchIndexerConfig build() throws ConfigException {
        return new ImmutableYcSearchIndexerConfig(
            this);
    }

    @Override
    public YcSearchIndexerConfigBuilder self() {
        return this;
    }
}
