package ru.yandex.search.yc.config;

import java.util.Collections;
import java.util.Map;

import ru.yandex.client.producer.ProducerClientConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;
import ru.yandex.search.yc.BadIndexMessageAction;
import ru.yandex.search.yc.IndexationTargetFactory;
import ru.yandex.search.yc.schema.YcSearchIndexDocParser;
import ru.yandex.search.yc.schema.YcSearchSchemaV1Parser;

public class YcSearchIndexerConfigDefaults
     extends UniversalSearchProxyConfigDefaults
     implements YcSearchIndexerConfig
{
    public static final YcSearchIndexerConfigDefaults INSTANCE =
        new YcSearchIndexerConfigDefaults();

    protected YcSearchIndexerConfigDefaults() {
    }

    @Override
    public BadIndexMessageAction badIndexMessageAction() {
        return BadIndexMessageAction.HALT;
    }

    @Override
    public String malformedDocsService() {
        return null;
    }

    @Override
    public Map<String, YcSearchIndexDocParser> schemas() {
        return Collections.singletonMap("v1", new YcSearchSchemaV1Parser());
    }

    @Override
    public IndexationTargetFactory indexationTarget() {
        return IndexationTargetFactory.PRODUCER;
    }

    @Override
    public ProducerClientConfig marketProducerClientConfig() {
        return null;
    }

    @Override
    public FieldGroupingElementStatersConfig serviceStatConfig() {
        return FieldGroupingElementStatersConfigDefaults.INSTANCE;
    }

    @Override
    public FieldGroupingElementStatersConfig marketStatConfig() {
        return FieldGroupingElementStatersConfigDefaults.INSTANCE;
    }
}
