package ru.yandex.search.yc.schema;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.search.yc.YcDoc;
import ru.yandex.search.yc.YcIndexFields;

public abstract class AbstractSearchIndexSchemaParser implements YcSearchIndexDocParser {
    protected static final JsonValidator VALIDATOR
        = JsonSchemaFactory.byDefault().getValidator();

    private final JsonNode schemaJsonNode;
    public AbstractSearchIndexSchemaParser(final String schemaPath) throws IOException {
        schemaJsonNode = JsonLoader.fromResource(schemaPath);
    }

    public AbstractSearchIndexSchemaParser(final File file) throws IOException {
        schemaJsonNode = JsonLoader.fromFile(file);
    }

    @Override
    public YcDoc parse(final Logger logger, final JsonMap document, final long transferTs) throws Exception {
        ProcessingReport report =
            VALIDATOR.validate(
                schemaJsonNode,
                JsonLoader.fromString(JsonType.NORMAL.toString(document)),
                true);

        // kostyl for monitoring ids
        if (!report.isSuccess()
                && "monitoring".equalsIgnoreCase(
                    document.getString(YcIndexFields.SERVICE, null)))
        {
            JsonMap monitoringDoc = document.deepCopy();
            String id = monitoringDoc.getString("resource_id", "");
            monitoringDoc.replace("resource_id", new JsonString(id.replaceAll("-", "")));
            monitoringDoc.replace("original_resource_id", new JsonString(id));
            report =
                VALIDATOR.validate(
                    schemaJsonNode,
                    JsonLoader.fromString(JsonType.NORMAL.toString(monitoringDoc)),
                    true);
            logger.warning("Try to workaround monitoring, suceedeed: " + report.isSuccess());
        }

        if (report.isSuccess()) {
            return parseValidated(document, transferTs);
        }

        logger.warning(
            "Failed to workaround malformed for service " + document.getString(YcIndexFields.SERVICE, null));
        StringBuilder errorSb = new StringBuilder();
        Iterator<ProcessingMessage> iterator = report.iterator();
        while (iterator.hasNext()) {
            ProcessingMessage message = iterator.next();
            if (message.getLogLevel() == LogLevel.ERROR
                || message.getLogLevel() == LogLevel.FATAL)
            {
                errorSb.append(message);
            }
        }
        throw new SchemaValidationException(errorSb.toString());
    }


    protected abstract YcDoc parseValidated(final JsonMap document, final long transferTs) throws JsonException;
}
