package ru.yandex.search.yc.schema;

import java.io.IOException;
import java.util.logging.Logger;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;
import ru.yandex.search.yc.YcDoc;
import ru.yandex.search.yc.YcIndexFields;
import ru.yandex.search.yc.YcIndexer;
import ru.yandex.search.yc.YcSearchIndexer;

public class YcSearchIndexSelectSchemaParser {
    private final YcSearchIndexDocParser v2Parser;
    private final YcSearchIndexDocParser v1Parser;
    private final YcSearchIndexer indexer;

    public YcSearchIndexSelectSchemaParser(final YcSearchIndexer indexer) throws IOException {
        this.indexer = indexer;
        YcIndexer server = indexer.server();
        v1Parser = server.config().schemas().get("v1");
        v2Parser = server.config().schemas().get("v2");
        server.logger().info("Parsers " + server.config().schemas());
    }

    public YcDoc parse(
        final Logger logger,
        final JsonMap document,
        final long transferTs)
        throws Exception
    {
        String deleted = document.getString(YcIndexFields.DELETED, null);
        if (deleted != null && deleted.isEmpty()) {
            document.remove("deleted");
        }

        String reindexTimestamp = document.getString(YcIndexFields.REINDEX_TIMESTAMP, null);
        if (reindexTimestamp != null && reindexTimestamp.isEmpty()) {
            document.remove("reindexTimestamp");
        }

        JsonObject nameObj = document.get(YcIndexFields.NAME);
        JsonObject resourcePath = document.get(YcIndexFields.RESOURCE_PATH);
        if (nameObj != null && nameObj != JsonNull.INSTANCE
            && resourcePath != null && resourcePath != JsonNull.INSTANCE)
        {
            //logger.info("Using V2 parser");
            YcDoc doc = v2Parser.parse(logger,document, transferTs);
            indexer.schemaV2ByService().getOrCreate(doc.service()).accept(1L);
            return doc;
        }

        logger.warning("Using V1 parser " + JsonType.NORMAL.toString(nameObj) + " " + JsonType.NORMAL.toString(resourcePath));
        YcDoc doc = v1Parser.parse(logger, document, transferTs);
        indexer.schemaV1ByService().getOrCreate(doc.service()).accept(1L);
        return doc;
    }


}
