JAVA_PROGRAM(yc_indexer)

JDK_VERSION(11)

OWNER(g:personal-search)

INCLUDE(${ARCADIA_ROOT}/mail/persdata/build/strict_java_check.inc)

JAVA_SRCS(SRCDIR main/java **/*.java)
JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/cloud/search/schemas **/event.json)

EXCLUDE(contrib/java/javax/activation/activation/1.1)

PEERDIR(
    contrib/java/javax/xml/bind/jaxb-api/2.3.1
    contrib/java/org/slf4j/slf4j-jdk14/1.5.3
    contrib/java/com/github/java-json-tools/json-schema-validator/2.2.14
    cloud/bitbucket/private-api/yandex/cloud/priv/iam/v1
    mail/contrib/httpcomponents/httpclient/httpmime
    mail/library/zoolooser/dispatcher_zk
    mail/library/logbroker/logbroker2_consumer
    mail/library/multistarter
    mail/search/universal_search_proxy
    mail/search/yc/yc_base
)

DEPENDENCY_MANAGEMENT(
    contrib/java/com/fasterxml/jackson/core/jackson-databind/2.9.6
#    contrib/java/io/grpc/grpc-protobuf/1.40.1
#    contrib/java/io/grpc/grpc-protobuf-lite/1.40.1
#    contrib/java/com/google/api/grpc/proto-google-common-protos/2.0.1
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/mail/tools/templates/classpath.template.sh
    OUT ${BINDIR}/classpath.sh
    CUSTOM_PROPERTY packageName yc_indexer
)


END()

IF (SANITIZER_TYPE != "memory" AND SANITIZER_TYPE != "undefined")
    RECURSE_FOR_TESTS(
        test
    )
ENDIF()

