#!/bin/bash
set -exo pipefail
source classpath.sh

export LOGS_DIR="/var/log/yc/search/yc_search_queue/"
export YC_SEARCH_BASE_DIR="/usr/yc/search"
export YC_SEARCH_APP_DIR="$YC_SEARCH_BASE_DIR/yc_search_queue"
export LD_LIBRARY_PATH=$YC_SEARCH_APP_DIR
export LANG=en_US.UTF-8
export CPU_CORES=6
export MEMORY_LIMIT=$((1024*1024*1024*14))


case "$TYPE" in
  docker)
    echo "Docker deployment detection. PWD: $(pwd), source config: $ENV/yc_search_queue.sh"
    export QUEUE_CONFIG_PATH="yc_search_queue_israel_$INDEX.conf"
    echo $INDEX > /media/yc/search/queue/data/myid
    ;;
  *)
    export QUEUE_CONFIG_PATH="yc_search_queue.conf"
    ;;
esac

source yc_search_queue_gc_args.sh

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"

APP_ARGS="-Dzookeeper.log.dir=$LOGS_DIR
    -Dzookeeper.root.logger=INFO,ROLLINGFILE
    -Dzookeeper.forceSync=no
    -Djute.maxbuffer=64000000
    -Dzookeeper.skipACL=yes
    -Dzookeeper.snapCount=4000000
    -Djava.library.path=$YC_SEARCH_APP_DIR/yc_queue
    -Dzoolooser.traffic-compress.zstd=false"

exec $YC_SEARCH_APP_DIR/jdk/bin/java \
    -Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.SimpleLog \
    -Dorg.apache.commons.logging.simplelog.showdatetime=false \
    -Dorg.apache.commons.logging.simplelog.log.org.apache.http=OFF \
    -Dorg.apache.commons.logging.simplelog.log.org.apache.http.wire=OFF \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -cp $CLASSPATH \
	  org.apache.zookeeper.server.quorum.QuorumPeerMain \
    ./$QUEUE_CONFIG_PATH

