#!/bin/sh
if [ -x gc_args.sh.overrides ]; then
	exec ./gc_args.sh.overrides
    exit 0;
fi

GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
XMX=$((MEMORY_LIMIT-GB1_5))

export GC_ARGS="
-XX:+DisableExplicitGC
-Xlog:gc*:/dev/shm/gclogs/gc.log
-XX:+UnlockExperimentalVMOptions
-XX:+UseG1GC
-Xmx$XMX
-Xms$XMX
-Xmn512M
-XX:ParallelGCThreads=6
-XX:ConcGCThreads=2
-XX:MaxGCPauseMillis=50
-XX:G1MixedGCCountTarget=32
-XX:G1HeapWastePercent=20
-XX:G1AdaptiveIHOPNumInitialSamples=10
-XX:+PrintGCDetails
--add-opens java.base/java.nio=ALL-UNNAMED
--add-opens java.base/sun.nio=ALL-UNNAMED
--add-opens java.base/sun.nio.ch=ALL-UNNAMED
--add-opens java.base/java.lang=ALL-UNNAMED
-XX:+DisableExplicitGC
-Xlog:gc*:/dev/shm/gclogs/gc.log
-XX:+UnlockExperimentalVMOptions
-XX:+UseZGC
-Xmx$XMX
-Xms$XMX
-XX:ParallelGCThreads=6
-XX:ConcGCThreads=2
"
