#!/bin/bash
set -exo pipefail

source classpath.sh
case "$TYPE" in
  docker)
    echo "Docker deployment detection. PWD: $(pwd), source config: $ENV/yc_search_proxy_config.sh"
    source $ENV/yc_search_proxy_config.sh
    export DC_ZONE=$ZONE
    export PRODUCER_CLOUD_HOST="$INDEXER_HOST_TEMPLATE-$DC_ZONE-$INDEX.$(hostname -d):8080"
    export SEARCHMAP_PATH="/usr/yc/search/$ENV/searchmap_yc.txt"
    touch $SEARCHMAP_PATH
    ;;
  *)
    source yc_search_proxy_config.sh
    export DC_ZONE=$(hostname -s | grep -oE '\-rc1([a,b,c])')
    export PRODUCER_CLOUD_HOST="$INDEXER_HOST_TEMPLATE$DC_ZONE.$(hostname -d):8080"
    export SEARCHMAP_PATH="/usr/yc/search/searchmap_yc.txt"
    touch $SEARCHMAP_PAT
    ;;
esac

#source yc_search_proxy_config.sh

#export SEARCHMAP_PATH="/usr/yc/search/searchmap_yc.txt"
#touch $SEARCHMAP_PATH

export YC_PROXY_CONFIG="yc_search_proxy_http.conf"
export FULL_LOG_FILE="/var/log/yc/search/yc_search_proxy/full.log"
export ACCESS_LOG_FILE="/var/log/yc/search/yc_search_proxy/access.log"
export YC_SEARCH_BASE_DIR="/usr/yc/search"

#export DC_ZONE=$(hostname -s | grep -oE '\-rc1([a,b,c])')
#export PRODUCER_CLOUD_HOST="$(hostname -s | egrep -o '^[a-z\-]+' | sed  's/ycsearch\-proxy/ycsearch\-indexer/g')0$PRODUCER_HOST_INDEX$DC_ZONE.$(hostname -d):8080"
#export PRODUCER_CLOUD_HOST="$INDEXER_HOST_TEMPLATE$DC_ZONE.$(hostname -d):8080"

export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

export YC_PROXY_CONFIG="yc_search_proxy_cloud.conf"

export CPU_CORES=5
export MEMORY_LIMIT=$((1024*1024*1024*6))

export PROXY_WORKERS=$((CPU_CORES / 2))
if [ "$PROXY_WORKERS" -lt 1 ]; then
    export PROXY_WORKERS=1
fi

GB=$((1024*1024*1024))
XMX=$((MEMORY_LIMIT-GB))
XMS=$((XMX / 4))

MEM_ARGS="-Xms${XMS} -Xmx${XMX}  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-XX:ActiveProcessorCount=${CPU_CORES} -Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"

exec /usr/yc/search/yc_search_proxy/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=yc_search_proxy \
    -DYC_QUEUE=$YC_QUEUE \
    -DYC_MARKETPLACE_QUEUE=$YC_MARKETPLACE_QUEUE \
    -cp $CLASSPATH \
    ru.yandex.search.yc.YcSearchProxy \
    yc_search_proxy_cloud.conf

