package ru.yandex.search.yc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import yandex.cloud.priv.servicecontrol.v1.PR;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.search.yc.iam.IamResourceFilter;
import ru.yandex.yc.search.YcSearchFields;


public class BasicYcResultItem implements JsonValue, FilterableResource {
    protected final Map<String, JsonObject> fields;
    protected final String docId;
    protected final String service;
    protected final String permission;
    protected final String resourceId;
    protected final String resourceType;
    protected final String folderId;
    protected final String cloudId;
    protected final List<PR.Resource> resourcePath;
    protected final Double score;

    public BasicYcResultItem(final JsonMap map) throws JsonException {
        this.fields = new LinkedHashMap<>(YcCommonFields.values().length);

        for (Map.Entry<String, JsonObject> entry: map.entrySet()) {
            YcCommonFields common = YcCommonFields.convert(entry.getKey());
            if (common != null) {
                JsonObject value;
                if (common == YcCommonFields.ATTRIBUTES) {
                    value = TypesafeValueContentHandler.parse(entry.getValue().asString());
                } else {
                    value = entry.getValue();
                }

                fields.put(common.fieldName(), value);
            }
        }

        this.resourceId = this.fields.get(YcCommonFields.RESOURCE_ID.fieldName()).asString();
        this.folderId = this.fields.get(YcCommonFields.FOLDER_ID.fieldName()).asString();
        this.permission = this.fields.get(YcCommonFields.PERMISSION.fieldName()).asStringOrNull();
        this.cloudId = this.fields.get(YcCommonFields.CLOUD_ID.fieldName()).asString();
        this.service = this.fields.get(YcCommonFields.SERVICE.fieldName()).asString();
        this.resourceType = map.getString(YcSearchFields.YC_RESOURCE_TYPE.stored(), "");
        this.score = map.getDouble("#score", 0.0d);
        List<PR.Resource> resourcePath;
        String resourcePathStr = map.getString(YcSearchFields.YC_RESOURCE_PATH.stored(), null);

        if (resourcePathStr != null) {
            JsonList resList = TypesafeValueContentHandler.parse(resourcePathStr).asList();
            resourcePath = new ArrayList<>(resList.size());
            for (JsonObject resObj: resList) {
                JsonMap resMap = resObj.asMap();
                resourcePath.add(
                    PR.Resource.newBuilder()
                        .setType(resMap.getString("resource_type"))
                        .setId(resMap.getString("resource_id"))
                        .build());

            }
            fields.put("resource_path", resList);
        } else {
            resourcePath = Collections.singletonList(
                PR.Resource.newBuilder()
                    .setType(IamResourceFilter.RESOURCE_TYPE_FOLDER)
                    .setId(folderId)
                    .build()
            );
        }

        this.resourcePath = resourcePath;
        this.docId = YcFields.mainDocId(cloudId, service, resourceType, resourceId);
    }

    public String docId() {
        return docId;
    }

    public String service() {
        return service;
    }

    public Map<String, JsonObject> fields() {
        return fields;
    }

    public Double score() {
        return score;
    }

    @Override
    public String permission() {
        return permission;
    }

    @Override
    public String resourceId() {
        return resourceId;
    }

    public String resourceType() {
        return resourceType;
    }

    @Override
    public String folderId() {
        return folderId;
    }

    @Override
    public String cloudId() {
        return cloudId;
    }

    @Override
    public List<PR.Resource> resourcePath() {
        return resourcePath;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.value(fields);
    }

    @Override
    public String toString() {
        return "BasicYcResultItem{" +
                   "docId='" + docId + '\'' +
                   ", service='" + service + '\'' +
                   ", resourceId='" + resourceId + '\'' +
                   ", resourceType='" + resourceType + '\'' +
                   ", folderId='" + folderId + '\'' +
                   ", cloudId='" + cloudId + '\'' +
                   '}';
    }
}
