package ru.yandex.search.yc;

import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;

import org.apache.http.client.protocol.HttpClientContext;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.json.writer.JsonType;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.StringPrefix;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class BasicYcSearchContext
    implements UniversalSearchProxyRequestContext,
    RequestProvider,
    YcContextProvider,
    RelevanceBoostProvider
{
    protected final ProxySession session;
    protected final Supplier<? extends HttpClientContext> contextGenerator;
    protected final YcSearchProxy proxy;
    protected final User user;

    protected final Prefix prefix;
    protected final Set<String> cloudIds;
    protected final MultiCloudYCSearchContext context;
    protected final PrefixedLogger logger;

    /**
     *
     * @param proxy
     * @param context
     * @param cloudIds - expecting not empty
     * @throws BadRequestException
     */
    public BasicYcSearchContext(
        final YcSearchProxy proxy,
        final MultiCloudYCSearchContext context,
        final Set<String> cloudIds)
        throws BadRequestException
    {
        this.context = context;
        this.proxy = proxy;
        this.session = context.session();

        this.cloudIds = cloudIds;
        this.logger = context.session.logger();
        prefix = new StringPrefix(YcFields.buildPrefix(cloudIds.iterator().next()));

        contextGenerator =
            session.listener().createContextGeneratorFor(context.client());

        user = new User(YcConstants.YC_QUEUE, prefix);
    }

    public String iamToken() {
        return context.iamToken();
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return context.client();
    }

    @Override
    public PrefixedLogger logger() {
        return session.logger();
    }

    @Override
    public long lagTolerance() {
        return context.allowLaggingHosts() ? Long.MAX_VALUE : 0L;
    }

    @Override
    public String request() {
        return context.request();
    }

    @Override
    public BasicYcSearchContext searchContext() {
        return this;
    }

    public ProxySession session() {
        return session;
    }

    public JsonType jsonType() {
        return context.jsonType();
    }

    public Supplier<? extends HttpClientContext> contextGenerator() {
        return contextGenerator;
    }

    public YcSearchProxy proxy() {
        return proxy;
    }

    public Prefix prefix() {
        return prefix;
    }

    public Locale locale() {
        return context.locale();
    }

    public int length() {
        return context.length();
    }

    public int offset() {
        return context.offset();
    }

    public boolean debug() {
        return context.debug();
    }

    public boolean highlight() {
        return context.highlight();
    }

    public Set<String> cloudIds() {
        return cloudIds;
    }

    @Override
    public String currentFolderId() {
        return context.folderId();
    }

    @Override
    public String currentCloudId() {
        return null;
    }

    public MultiCloudYCSearchContext topContext() {
        return context;
    }
}
