package ru.yandex.search.yc;

import org.apache.http.Header;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;

public class TokenRequiredYcSearchContext {
    private final String iamToken;

    public TokenRequiredYcSearchContext(final ProxySession session) throws BadRequestException {
        Header tokenHeader = session.request().getFirstHeader(YcHeaders.SUBJECT_TOKEN);
        if (tokenHeader == null || tokenHeader.getValue().isEmpty()) {
            throw new BadRequestException(YcHeaders.SUBJECT_TOKEN + " header is required");
        }

        iamToken = tokenHeader.getValue();
    }

    public String iamToken() {
        return iamToken;
    }
}
