package ru.yandex.search.yc;

import java.io.IOException;

import ru.yandex.collection.Pattern;
import ru.yandex.search.proxy.universal.UniversalSearchProxy;
import ru.yandex.search.yc.config.ImmutableYCProxyConfig;
import ru.yandex.search.yc.iam.IamResourceFilter;
import ru.yandex.search.yc.labels.LabelsHandler;
import ru.yandex.search.yc.marketplace.MarketPlaceSearchHandler;
import ru.yandex.search.yc.marketplace.MarketplaceAggregationHandler;

public class YcSearchProxy
    extends UniversalSearchProxy<ImmutableYCProxyConfig>
{
    private final IamResourceFilter resourceFilter;

    public YcSearchProxy(final ImmutableYCProxyConfig config)
        throws IOException
    {
        super(config);

        this.register(
            new Pattern<>("/api/search", false),
            new SearchHandler(this));
        this.register(
            new Pattern<>("/api/resource/meta", false),
            new YcSearchResourceMetaHandler(this));
        this.register(
            new Pattern<>("/api/labels/list", false),
            new LabelsHandler(this));
        this.register(
            new Pattern<>("/api/parse_errors", false),
            new YcMalformedDocsListHandler(this));
        this.register(
            new Pattern<>("/api/marketplace/search", false),
            new MarketPlaceSearchHandler(this));
        this.register(
            new Pattern<>("/api/marketplace/aggregation", false),
            new MarketplaceAggregationHandler(this));

        this.resourceFilter = new IamResourceFilter(this);
    }

    public IamResourceFilter resourceFilter() {
        return resourceFilter;
    }
}
