package ru.yandex.search.yc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class YcSearchResult<T extends BasicYcResultItem>
    extends ArrayList<T>
    implements JsonValue
{
    private final Set<String> docIds = new LinkedHashSet<>();
    public static final long serialVersionUID = 0;

    public YcSearchResult(final int initialCapacity) {
        super(initialCapacity);
    }

    public YcSearchResult() {
    }

    public YcSearchResult(final Collection<? extends T> c) {
        addAll(c);
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
    }

    @Override
    public boolean add(final T item) {
        if (docIds.add(item.docId())) {
            return super.add(item);
        }

        return false;
    }

    @Override
    public boolean addAll(final Collection<? extends T> c) {
        boolean changed = false;
        for (T item: c) {
            changed |= add(item);
        }

        return changed;
    }
}
