package ru.yandex.search.yc;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.collection.IntInterval;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.PositionSavingContainerFactory;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.ps.search.field.PrefixedStoredField;
import ru.yandex.search.ps.highlight.IntervalHighlighter;

public class YcSearchResultItem extends BasicYcResultItem implements JsonValue, FilterableResource {
    private Boolean highlighted = false;
    private final JsonMap map;
    private final BasicYcSearchContext context;
    public YcSearchResultItem(final JsonMap map, final BasicYcSearchContext context) throws JsonException {
        super(map);
        this.map = map;
        this.context = context;
    }

    protected void highlights(boolean ignoreMergedDocs, boolean noMorphoListAtFirst, boolean firstHighlightListOnly)
        throws JsonException
    {
        if (!context.highlight() || context.request().isEmpty() || highlighted) {
            return;
        }
        context.logger().info("Highlighting starts");
        this.highlighted = true;
        JsonMap attrsHighlights = new JsonMap(PositionSavingContainerFactory.INSTANCE);
        Map<String, String> foundAttributesNames = new LinkedHashMap<>();
        // highlight
        JsonMap highlights = new JsonMap(BasicContainerFactory.INSTANCE);

        String attName = map.getString(YcFields.ATTRIBUTE_NAME.storeField(), null);
        String attValue = map.getString(YcFields.ATTRIBUTE_VALUE.storeField(), null);
        if (attName != null && attValue != null && !attValue.isEmpty()) {
            foundAttributesNames.put(attName, attValue);
        }
        if (!ignoreMergedDocs) {
            JsonList merged = map.getListOrNull("merged_docs");
            if (merged != null) {
                for (JsonObject mergedDoc: merged) {
                    JsonMap mergedDocMap = mergedDoc.asMap();
                    attName = mergedDocMap.getString(YcFields.ATTRIBUTE_NAME.storeField());
                    attValue = mergedDocMap.getString(YcFields.ATTRIBUTE_VALUE.storeField());

                    if (attName != null && attValue != null && !attValue.isEmpty()) {
                        foundAttributesNames.put(attName, attValue);
                    }
                }
            }
        }

        List<String> prepared =
            IntervalHighlighter.INTANCE.prepareRequest(context.request());

        // resourceId
        for (PrefixedStoredField mainField: YcPlainSearchRule.MAIN_DOC_SEARCH_FIELDS) {
            String mainFieldValue = map.getString(mainField.stored(), null);
            if (mainFieldValue != null) {
                List<IntInterval> intervals =
                    IntervalHighlighter.INTANCE.highlightIntervals(
                        mainFieldValue,
                        prepared,
                        true,
                        true);
                if (!intervals.isEmpty()) {
                    highlights.put(
                        YcCommonFields.convert(mainField.name()).fieldName(),
                        intervalsToJson(intervals));
                }
            }
        }
        context.logger().info("Finished highlighting intervals for MAIN_DOC_SEARCH_FIELDS");
//        String resourceId = map.getString(YcFields.RESOURCE_ID.storeField(), null);
//        if (resourceId != null) {
//            List<IntInterval> intervals =
//                IntervalHighlighter.INTANCE.highlightIntervals(
//                    resourceId,
//                    prepared,
//                    true,
//                    true);
//            if (!intervals.isEmpty()) {
//                highlights.put(
//                    YcCommonFields.RESOURCE_ID.fieldName(),
//                    intervalsToJson(intervals));
//            }
//        }

        JsonObject attributesObj = fields.get(YcCommonFields.ATTRIBUTES.fieldName());
        if (!foundAttributesNames.isEmpty() && attributesObj != null) {
            JsonMap attributes = attributesObj.asMap();

            for (Map.Entry<String, String> entry: foundAttributesNames.entrySet()) {
                String foundAttName = entry.getKey();
                context.logger().info("Processing " + foundAttName);
                StringBuilder sb = new StringBuilder();
                if (foundAttName.startsWith("label_")) {
                    sb.append("labels.");
                    sb.append(foundAttName.substring(6));
                    List<IntInterval> intervals = IntervalHighlighter.INTANCE.highlightIntervals(
                            entry.getValue(),
                            prepared,
                            true,
                            true);
                    if (intervals.isEmpty()) {
                        attrsHighlights.put(
                            sb.toString(),
                            intervalsToJson(
                                Collections.singletonList(
                                    new IntInterval(0, entry.getValue().length()))));
                    } else {
                        attrsHighlights.put(sb.toString(), intervalsToJson(intervals));
                    }
                } else {
                    sb.append(foundAttName);
                    JsonObject value = attributes.get(foundAttName);
                    switch (value.type()) {
                        case LIST:
                            if (noMorphoListAtFirst) {
                                boolean highlightFound = highlightList(value, sb, context, attrsHighlights, prepared,
                                    false, firstHighlightListOnly);
                                if (!highlightFound) {
                                    highlightList(value, sb, context, attrsHighlights, prepared,
                                        true, firstHighlightListOnly);
                                }
                            } else {
                                highlightList(value, sb, context, attrsHighlights, prepared,
                                    true, firstHighlightListOnly);
                            }
                            context.logger().info("Finished highlighting list");
                            break;
                        default:
                            List<IntInterval> intervals = IntervalHighlighter.INTANCE.highlightIntervals(
                                    value.asString(),
                                    prepared,
                                    true,
                                    true);
                            if (intervals.isEmpty()) {
                                attrsHighlights.put(
                                    sb.toString(),
                                    intervalsToJson(
                                        Collections.singletonList(
                                            new IntInterval(0, entry.getValue().length()))));
                            } else {
                                attrsHighlights.put(sb.toString(), intervalsToJson(intervals));
                            }
                    }
                }
            }
        }

        if (!attrsHighlights.isEmpty()) {
            highlights.put(YcCommonFields.ATTRIBUTES.fieldName(), attrsHighlights);
            fields.put(YcCommonFields.ATTRIBUTES.fieldName() + "_highlights", attrsHighlights);
        }

        context.logger().info("Finished highlighting");
        fields.put("search_highlights", highlights);
        context.logger().info("finished highlighting");
    }

    private boolean highlightList(JsonObject value, StringBuilder sb, BasicYcSearchContext context,
                               JsonMap attrsHighlights, List<String> prepared, boolean morpho, boolean firstOnly)
        throws JsonException {
        JsonList list = value.asList();
        context.logger().info("Highlighting list, size =" + list.size());
        boolean highlightFound = false;
        for (int i = 0; i < list.size(); i++) {
            List<IntInterval> intervals = IntervalHighlighter.INTANCE.highlightIntervals(
                list.get(i).asString(),
                prepared,
                true,
                morpho);
            if (!intervals.isEmpty()) {
                int length = sb.length();
                sb.append('.');
                sb.append(i);

                attrsHighlights.put(sb.toString(), intervalsToJson(intervals));
                sb.setLength(length);
                highlightFound = true;
                if (firstOnly) {
                    return highlightFound;
                }
            }
        }
        return highlightFound;
    }

    private JsonObject intervalsToJson(final List<IntInterval> intervals) {
        JsonList list = new JsonList(PositionSavingContainerFactory.INSTANCE);
        for (IntInterval interval: intervals) {
            JsonList subList = new JsonList(PositionSavingContainerFactory.INSTANCE);
            subList.add(new JsonLong(interval.min()));
            subList.add(new JsonLong(interval.max()));
            list.add(subList);
        }

        return list;
    }
}
