package ru.yandex.search.yc;

import java.io.IOException;
import java.util.Comparator;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;

public class YcSearchResultPrinter
    extends AbstractProxySessionCallback<YcSearchResult<BasicYcResultItem>>
{
    private final MultiCloudYCSearchContext context;

    public YcSearchResultPrinter(
        final MultiCloudYCSearchContext context)
    {
        super(context.session());
        this.context = context;
    }

    @Override
    public void completed(final YcSearchResult<BasicYcResultItem> result) {
        StringBuilderWriter sbw = new StringBuilderWriter();

        context.session().connection().setSessionInfo(
            SearchProxyAccessLoggerConfigDefaults.HITS_COUNT,
            Long.toString(result.size()));

        try (JsonWriter writer = context.jsonType().create(sbw)) {
            writer.startObject();
            writer.key("results");
            writer.startArray();
            result.sort((Comparator.comparingDouble(BasicYcResultItem::score)).reversed());
            for (int i = context.offset; i < Math.min(result.size(), context.offset + context.length); i++) {
                writer.value(result.get(i));
            }
            writer.endArray();
            writer.endObject();
        } catch (IOException ioe) {
            failed(ioe);
            return;
        }

        session.response(
            HttpStatus.SC_OK,
            new NStringEntity(
                sbw.toString(),
                ContentType.APPLICATION_JSON
                    .withCharset(context.session().acceptedCharset())));
    }
}
