package ru.yandex.search.yc.config;

import java.util.function.Predicate;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;
import ru.yandex.search.yc.AllowedServicesParser;

public abstract class AbstractYCProxyConfigBuilder
    <T extends AbstractYCProxyConfigBuilder<T>>
     extends AbstractUniversalSearchProxyConfigBuilder<T>
     implements YCProxyConfig
{
    private GrpcHostConfigBuilder iamConfig;
    private long searchFailOverDelay;
    private Predicate<String> allowedServices;

    protected AbstractYCProxyConfigBuilder(final YCProxyConfig config) {
        super(config);

        searchFailOverDelay(config.searchFailOverDelay());
        iamConfig(config.iamConfig());
        allowedServices(config.allowedServices());
    }

    protected AbstractYCProxyConfigBuilder(
        final IniConfig config,
        final YCProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.searchFailOverDelay =
            config.getLong(
                "search-fail-over-delay",
                defaults.searchFailOverDelay());
        this.iamConfig =
            new GrpcHostConfigBuilder(
                config.section("iam"),
                defaults.iamConfig());

        allowedServices =
            config.get("allowed-services", defaults.allowedServices(), AllowedServicesParser.INSTANCE);
    }

    @Override()
    public long searchFailOverDelay() {
        return searchFailOverDelay;
    }

    public T searchFailOverDelay(final long value) {
        this.searchFailOverDelay = value;
        return self();
    }

    @Override
    public GrpcHostConfigBuilder iamConfig() {
        return iamConfig;
    }

    public T iamConfig(final GrpcHostConfig iamConfig) {
        this.iamConfig = new GrpcHostConfigBuilder(iamConfig);
        return self();
    }

    @Override
    public Predicate<String> allowedServices() {
        return allowedServices;
    }

    public T allowedServices(final Predicate<String> allowedServices) {
        this.allowedServices = allowedServices;
        return self();
    }
}
