package ru.yandex.search.yc.config;

import java.util.function.Predicate;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableYCProxyConfig
     extends ImmutableUniversalSearchProxyConfig
     implements YCProxyConfig
{
    private final long searchFailOverDelay;
    private final ImmutableGrpcHostConfig iamConfig;
    private final Predicate<String> allowedServices;

    public ImmutableYCProxyConfig(
        final YCProxyConfig config)
        throws ConfigException
    {
        super(config);
        this.searchFailOverDelay = config.searchFailOverDelay();
        this.allowedServices = config.allowedServices();
        this.iamConfig = new GrpcHostConfigBuilder(config.iamConfig()).build();
    }

    @Override
    public long searchFailOverDelay() {
        return searchFailOverDelay;
    }

    @Override
    public ImmutableGrpcHostConfig iamConfig() {
        return iamConfig;
    }

    @Override
    public Predicate<String> allowedServices() {
        return allowedServices;
    }
}
