package ru.yandex.search.yc.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class YCProxyConfigBuilder
     extends AbstractYCProxyConfigBuilder<YCProxyConfigBuilder>
{
    public YCProxyConfigBuilder() {
        this(YCProxyConfigDefaults.INSTANCE);
    }

    public YCProxyConfigBuilder(final YCProxyConfig config) {
        super(config);
    }

    public YCProxyConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, YCProxyConfigDefaults.INSTANCE);
    }

    public YCProxyConfigBuilder(
        final IniConfig config,
        final YCProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableYCProxyConfig build() throws ConfigException {
        return new ImmutableYCProxyConfig(
            this);
    }

    @Override
    public YCProxyConfigBuilder self() {
        return this;
    }
}
