package ru.yandex.search.yc.config;

import java.util.function.Predicate;

import ru.yandex.function.TruePredicate;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class YCProxyConfigDefaults
     extends UniversalSearchProxyConfigDefaults
     implements YCProxyConfig
{
    public static final YCProxyConfigDefaults INSTANCE =
        new YCProxyConfigDefaults();

    private static final long DEFAULT_FAILOVER_DELAY = 300;

    protected YCProxyConfigDefaults() {
    }

    @Override
    public long searchFailOverDelay() {
        return DEFAULT_FAILOVER_DELAY;
    }

    @Override
    public GrpcHostConfig iamConfig() {
        return GrpcHostConfigDefaults.INSTANCE;
    }

    @Override
    public Predicate<String> allowedServices() {
        return TruePredicate.instance();
    }
}
