package ru.yandex.search.yc.labels;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

import org.apache.http.client.protocol.HttpClientContext;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.json.writer.JsonType;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.searchmap.SearchMapShard;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;
import ru.yandex.search.yc.YcSearchProxy;

public class LabelsShardContext
    implements UniversalSearchProxyRequestContext
{
    protected final ProxySession session;
    protected final Supplier<? extends HttpClientContext> contextGenerator;
    protected final YcSearchProxy proxy;
    protected final List<User> users;
    protected final Set<String> cloudIds;
    protected final SearchMapShard shard;
    protected final LabelsContext context;
    protected final PrefixedLogger logger;

    public LabelsShardContext(
        final YcSearchProxy proxy,
        final LabelsContext context,
        final Map.Entry<SearchMapShard, List<User>> entry,
        final Set<String> cloudIds)
        throws BadRequestException
    {
        this.context = context;
        this.proxy = proxy;
        this.session = context.session();

        CgiParams params = session.params();

        this.cloudIds = cloudIds;
        this.logger = context.session.logger();
        this.users = entry.getValue();
        this.shard = entry.getKey();
        contextGenerator =
            session.listener().createContextGeneratorFor(context.client());
    }

    public Set<String> cloudIds() {
        return cloudIds;
    }

    public String iamToken() {
        return context.iamToken();
    }

    @Override
    public User user() {
        return users.get(0);
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return context.client();
    }

    @Override
    public PrefixedLogger logger() {
        return session.logger();
    }

    @Override
    public long lagTolerance() {
        return context.allowLaggingHosts() ? Long.MAX_VALUE : 0L;
    }

    public ProxySession session() {
        return session;
    }

    public JsonType jsonType() {
        return context.jsonType();
    }

    public Supplier<? extends HttpClientContext> contextGenerator() {
        return contextGenerator;
    }

    public YcSearchProxy proxy() {
        return proxy;
    }

    public int length() {
        return context.length();
    }

    public int offset() {
        return context.offset();
    }

    public boolean debug() {
        return context.debug();
    }
}
