package ru.yandex.search.yc.labels;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.yc.BasicYcResultItem;
import ru.yandex.search.yc.YcFields;

public class LabelsYcResultItem extends BasicYcResultItem {
    private final String labelName;
    private final String labelValue;

    public LabelsYcResultItem(final JsonMap map) throws JsonException {
        super(map);

        labelName = map.getString(YcFields.ATTRIBUTE_NAME.storeField());
        labelValue = map.getString(YcFields.ATTRIBUTE_VALUE.storeField());
    }

    public String labelName() {
        return labelName;
    }

    public String labelValue() {
        return labelValue;
    }
}
