package ru.yandex.search.yc.marketplace;

import ru.yandex.function.GenericUnaryOperator;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.search.yc.MarketplaceFieldType;

public class MarketplaceFieldParser
    implements GenericUnaryOperator<String, Exception>
{
    private final String project;

    public MarketplaceFieldParser(final String project) {
        this.project = project;
    }

    @Override
    public String apply(final String s) throws Exception {
        return MarketplaceFieldType.generateExtFieldName(project, NonEmptyValidator.TRIMMED.apply(s));
    }
}
