# SENDBERNAR
 Сервис **sendbernar** отвечает за композирование писем


## Архитектура
* qloud: https://platform.yandex-team.ru/projects/mail/sendbernar

| группа                              | суффикс            | число узлов |
| :---------------------------------- | :------------      | ----------: |
| mail_sendbernar_production          |                    |     **143** |
|                                     | _sendbernar        |         140 |
|                                     | _sendbernar-canary |           3 |
| mail_sendbernar_intranet-production |                    |      **9**  |
|                                     | _sendbernar        |           8 |
|                                     | _sendbernar-canary |           1 |


#### Структура контейнера

Сервис **sendbernar** живёт в отдельном контейнере. Кроме самого сервиса в контейнере располагаются другие вспомогательные сервисы: **nginx** (проксирует запросы извне, ограничивает rps), **supervisord** (следит за процессом сервиса, перезапускает сервисы). **unistat** в процессе добавления.


## Logs
* **nginx**:
    * **access** (/var/log/nginx/sendbernar/access.tskv)
* **sendbernar**:
    * **http_client** (/var/log/sendbernar/http_client.tskv) куда и как ходили по хттп
    * **access** (/var/log/sendbernar/access.tskv) лог для запросов, которые прошли проверку в nginx
    * **sendbernar** (/var/log/sendbernar/sendbernar.tskv) лог для общих сообщений, сюда же логируется ответ на запрос
    * **post_args** (/var/log/sendbernar/post_args.tskv) лог для всех аргументов запроса (часть аргументов замазывается)
    * **profiler** (/var/log/sendbernar/profiler.log)
    * **yplatform** (/var/log/sendbernar/yplatform.log) мусорный лог для странных непонятных писателей вроде ymod_tvm
* **прочие**:
    * supervisord (/var/log/supervisor/supervisord.log)


## Dashboards
* [production](https://yasm.yandex-team.ru/template/panel/sendbernar_panel/env=production/)
* [intranet-production](https://yasm.yandex-team.ru/template/panel/sendbernar_panel/env=intranet-production/)

![График распределения запросов за сутки по кластеру](https://yasm.yandex-team.ru/img/f59e40ac3fd89478017872f5d4601e29.png)

## Про сервис

https://wiki.yandex-team.ru/users/massaraksh/sendbernar/

Сервис в большинстве своём синхронный.

## Апи
Нет публичного HTTP-api (кроме двух ручек для xeno)
Вёрстка пользуется специальной js-библиотекой sendbernar_client

## Существующие http ручки
* Ручки для xeno (Участвуют первые две части)

/compose_draft

/compose_message
* Сохранение неготовых писем (Участвуют первые три части)

/save_draft

/save_template
* Отправка писем (Участвуют все части)

/send_message

* Отправка писем роботами

/send_service

* Отправка отменяемых писем писем (Участвуют все части + ремайндеры)

/send_delayed

/send_undo

/callback/send_delayed_message

/callback/send_undo_message

* Отмена отправок (Участвуют только базы)

/cancel_send_delayed

/cancel_send_undo

* Сохранение аттачей (Участвуют базы и мулькагейт)

/write_attachment

* Отправки системных писем (Участвует smtpgate)

/callback/no_answer_remind

/list_unsubscribe

## Части
Делится на 4 основные части:
* Предварительная обработка запроса

Запросы в шарпей, ЧЯ, настройки, в базу
* Компоуз письма

Собираем eml из параметров. Запросы в санитайзер, на статику за смайлами, в мулькагейт, в базу
* Отправка в smtpgate

Запрос в smtpgate
* Постобратобка

Ставим метки, пишем в user_journal, удаляем черновик, ходим базу, в ремайндеры


## Потребители 
* xeno
* reminders_worker
* reminders_worker_old
* liza
* webapi
* mobile
* lite


## Походы в базу
Сам сендбернар отсутствие мастера сильно заафектит, только если это не первое отправление письма. Но smtpgate черновик/отложенное сохранить не сможет, поэтому мы ответим 500. На обычную отправку это не повлияет, но не проставятся метки и не удалится черновик


## Походы по http
Сендбернар ходит в 10 сервисов. В некоторые сервисы ходим в разные ручки, которые очень сильно отличаются по поведению. Походы по http бывают с ожиданием ответа и без ожидания. То есть мы просто делаем запрос и сколько траев в фоне, успешность вызова не интересна.

* **blackbox**
Ходим в ручку userinfo за информацией о пользователе по юиду.
Таймаут 500мс
В случае ошибки ответим 500.

* **captcha**
Ходим генерировать новую и проверять введённую пользователем капчу
Таймаут 1000мс
В случае ошибки ответим 500.

* **reminders**
Есть новая и старая инсталяция ремайндеров. В новой создаются новые ремайндеры, из старой только удаляются перед установкой.
Установка и удаление всех ремайндеров происходит с ожиданием ответа, кроме ремайндера о неответе.
В случае ошибки ответим 500.

* **sanitizer**
Засылаем только html-письма и получаем список инлайновых аттачей
Таймаут 1000мс
В случае ошибки ответим 500.

* **settings**
~~Получаем несколько настроек пользователя: дефолтное имя, дефолтный адрес
Таймаут 2000мс
Если не получили ответ, то сфолбечимся к информации из паспорта или параметров запроса~~
Настройки теперь читаются из базы

* **sharpei**
Ходим для получения данных о метабазе и определяем живость мастера.
Таймаут 300мс
В случае ошибки ответим 410 или 500.

* **smtpgate**
Через него отправляем письма, сохраняем черновики, шаблоны и отложенные письма
/Черновики и шаблоны/
Таймаут 10000мс
В случае ошибки ответим 500.

_Отменяемые или отложенные письма_
Таймаут 30000мс
В случае ошибки ответим 500

_Отправка_
Таймаут 10000мс
В случае ошибки ответим много чем

_Отправка системных писем_
Таймаут 30000мс
В случае ошибки ответим 500


* **smiles**
Ходим за файлами на статику
Таймаут 500мс
В случае ошибки ответим 500

* **mulcagate**
Ходим чтоб складывать аттачи и доставать их
Таймаут на гет: 10000мс
Таймаут на пут: 30000мс
В случае ошибки ответим 500

## Коды ответа сервиса
* 200 - всё хорошо
* 400 - проблемы с аргументами
* 401 - проблемы с твм тикетом
* 402 - показываем капчу
* 405 - не тот HTTP метод
* 409 - спам
* 410 - мастер недоступен
* 413 - слишком большое письмо
* 500 - ошибка сервера
* 505 - не смогли отправить письмо, но сохранили черновик


## Частые ошибки

![График ответов smtpgate](https://jing.yandex-team.ru/files/massaraksh/2019-09-06_16-02-21.png)

![График ошибок sendbernar по типам](https://jing.yandex-team.ru/files/massaraksh/2019-09-06_16-02-26.png)

![График четырёхсоток по типам](https://jing.yandex-team.ru/files/massaraksh/2019-09-06_16-07-57.png)

![График траев до smtpgate](https://jing.yandex-team.ru/files/massaraksh/2019-09-06_16-08-22.png)

* *Рост спама*

Смотрим на ответы от smtpgate и уровень 402/409
* Проблемы с санитайзером

Смотрим на sanitizer_call_was_not_success
* Проблемы с базами

Просто всё плохо
* Проблемы с smtpgate

Смотрим на графики ошибок и траев от smtpgate
* Проблемы с СО или антивирусом

Смотрим на графики ошибок и траев от smtpgate
* Проблемы с ремайндерами

Корпоспецифичные проблемы, понимаем по 505 
* Проблемы с mds

Пятисотим и четырёхсотим
* Проблемы с настройками

Тайминги резко подскочили на 2сек
* Проблемы с ручками /compose*

Понимаем по ошибкам xeno

## Эксперименты
На корпе из Лизы на всех включен эксперимент и по умолчанию все письма отменяемые

