#pragma once

#include <mail_errors/error_code.h>
#include <mail/sendbernar/client/include/response_status.h>
#include <mail/sendbernar/client/include/delivery_result.h>
#include <mail/sendbernar/client/include/compose_result.h>
#include <mail/sendbernar/client/include/error_result.h>


namespace sendbernar {

struct SendbernarCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "sendbernar";
    }

    std::string message(int v) const override;
};

struct NwCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "delivery";
    }

    std::string message(int v) const override;
};

struct ComposeCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "compose";
    }

    std::string message(int v) const override;
};

const SendbernarCategory& getSendbernarCategory();
const NwCategory& getNwCategory();
const ComposeCategory& getComposeCategory();

ResponseStatus toResponseStatus(ErrorResult code);
ResponseStatus toResponseStatus(DeliveryResult code);
ResponseStatus toResponseStatus(ComposeResult code);

mail_errors::error_code::base_type make_error_code(DeliveryResult e);
mail_errors::error_code::base_type make_error_code(ErrorResult e);
mail_errors::error_code::base_type make_error_code(ComposeResult e);

mail_errors::error_code make_error(ErrorResult e, std::string what);
mail_errors::error_code make_error(DeliveryResult e);
mail_errors::error_code make_error(ComposeResult e);

}

namespace boost::system {

template <>
struct is_error_code_enum<sendbernar::ErrorResult> : std::true_type {};

template <>
struct is_error_code_enum<sendbernar::DeliveryResult> : std::true_type {};

template <>
struct is_error_code_enum<sendbernar::ComposeResult> : std::true_type {};

}
