#pragma once

#include <yamail/data/reflection/details/adt.h>

namespace sendbernar {

YREFLECTION_DEFINE_ENUM_INLINE(DeliveryResult,
    ok,
    spam,
    strongSpam,
    virus,
    badRecipient,
    unknownError,
    badRequest,
    badKarmaBanTime,
    sendMessageFailed,
    serviceUnavaliable,
    failedToAuthSender,
    badSender,
    toManyRecipients,
    sizeLimitExceeded
);

struct SendResult {
    DeliveryResult deliveryResult;
    std::optional<std::string> banReason;

    SendResult() = default;
    explicit SendResult(DeliveryResult deliveryResult) : deliveryResult(deliveryResult) {}
    explicit SendResult(DeliveryResult deliveryResult, std::optional<std::string> banReason) 
        : deliveryResult(deliveryResult) 
        , banReason(banReason)
        {}
};

}
