#pragma once

#include <mail/sendbernar/client/include/params.h>
#include <boost/fusion/include/adapt_struct.hpp>
#include <yamail/data/deserialization/json_reader.h>
#include <yamail/data/serialization/json_writer.h>


namespace sendbernar {
namespace params {

std::istream& operator>>(std::istream& in, IdetifiableMessagePart& p);
std::ostream& operator<<(std::ostream& out, const IdetifiableMessagePart& p);

std::istream& operator>>(std::istream& in, DiskAttach& p);
std::ostream& operator<<(std::ostream& out, const DiskAttach& p);

struct ContinueSendingMessageGetAdaptor {
    macs::Mid& mid;
    ContinueSendingMessageGetAdaptor(ContinueSendingMessage& csm)
        : mid(csm.mid)
    { }
};

struct CommonParamsHeaderAdapter {
    std::string& requestId;
    std::string& realIp;
    std::string& originalHost;

    CommonParamsHeaderAdapter(CommonParams& p)
        : requestId(p.requestId)
        , realIp(p.realIp)
        , originalHost(p.originalHost)
    { }
};

}
}

namespace sp = sendbernar::params;

YREFLECTION_ADAPT_ADT(sp::InReplyTo,
                      YREFLECTION_MEMBER(std::string, inreplyto)
                      (mark_as, std::string, std::string, sp::markAsToString(obj.mark_as), obj.mark_as = sp::markAsFromString(val))
                      )

YREFLECTION_ADAPT_ADT(sp::SendBarbetMessage,
    YREFLECTION_MEMBER(std::string, uniq_id)
    (type, std::string, std::string, sp::barbetMessageTypeToString(obj.type), obj.type = sp::barbetMessageTypeFromString(val))
)

BOOST_FUSION_ADAPT_STRUCT(sp::Attaches,
        (sp::opt<std::vector<sp::Stid>>, uploaded_attach_stids)
        (sp::opt<std::string>, disk_attaches)
        (sp::opt<std::vector<sp::DiskAttach>>, disk_attaches_json)
        (sp::opt<std::vector<sp::Mid>>, forward_mids)
        (sp::opt<sp::Parts>, parts_json) )

BOOST_FUSION_ADAPT_STRUCT(sp::Sender,
        (sp::opt<sp::Mailbox>, from_mailbox)
        (sp::opt<sp::Name>, from_name) )

BOOST_FUSION_ADAPT_STRUCT(sp::Message,
        (sp::opt<sp::Subject>, subj)
        (sp::opt<sp::Text>, text)
        (sp::opt<bool>, html)
        (sp::opt<sp::Mid>, source_mid)
        (sp::opt<std::time_t>, current_time)
        (sp::opt<bool>, force7bit)
        (sp::opt<sp::MessageId>, message_id) )

BOOST_FUSION_ADAPT_STRUCT(sp::Recipients,
        (sp::opt<sp::RecipientsStr>, to)
        (sp::opt<sp::RecipientsStr>, cc)
        (sp::opt<sp::RecipientsStr>, bcc) )

BOOST_FUSION_ADAPT_STRUCT(sp::Delivery,
        (sp::opt<std::time_t>, noanswer_remind_period)
        (sp::opt<bool>, confirm_delivery) )

BOOST_FUSION_ADAPT_STRUCT(sp::Captcha,
        (sp::CaptchaValue, captcha_entered)
        (sp::CaptchaKey, captcha_key) )

BOOST_FUSION_ADAPT_STRUCT(sp::NoAnswerReminder,
        (sp::Header, message_id)
        (unsigned, no_answer_period) )

BOOST_FUSION_ADAPT_STRUCT(sp::SaveTemplate,
        (sp::Attaches, attaches)
        (sp::Sender, sender)
        (sp::Message, message)
        (sp::Recipients, recipients)
        (sp::opt<sp::Lids>, lids) )

BOOST_FUSION_ADAPT_STRUCT(sp::SaveDraft,
        (sp::Attaches, attaches)
        (sp::Sender, sender)
        (sp::Message, message)
        (sp::Recipients, recipients)
        (sp::opt<sp::References>, references)
        (sp::opt<std::string>, inreplyto)
        (sp::opt<sp::Lids>, lids) )

BOOST_FUSION_ADAPT_STRUCT(sp::SendMessage,
        (sp::Attaches, attaches)
        (sp::Sender, sender)
        (sp::Message, message)
        (sp::Delivery, delivery)
        (sp::Recipients, recipients)
        (sp::opt<sp::Lids>, lids)
        (sp::opt<sp::Captcha>, captcha)
        (sp::opt<sp::CaptchaType>, captcha_type)
        (sp::opt<sp::References>, references)
        (sp::opt<sp::InReplyTo>, inreplyto)
        (sp::opt<sp::Mentions>, mentions)
        (sp::opt<std::string>, operation_id)
        (sp::opt<bool>, captcha_passed) )

BOOST_FUSION_ADAPT_STRUCT(sp::SendShare,
        attaches,
        message,
        recipients,
        lids,
        inreplyto,
        references,
        admin_uid
)

BOOST_FUSION_ADAPT_STRUCT(sp::SendDelayed,
        (std::time_t, send_time)
        (sp::SendMessage, send) )

BOOST_FUSION_ADAPT_STRUCT(sp::CancelSendDelayed,
        (sp::Mid, mid))

BOOST_FUSION_ADAPT_STRUCT(sp::LimitsParams,
        (sp::Recipients, recipients) )

BOOST_FUSION_ADAPT_STRUCT(sp::ComposeMessage,
        (sp::Attaches, attaches)
        (sp::Sender, sender)
        (sp::Message, message)
        (sp::Recipients, recipients)
        (sp::opt<sp::References>, references)
        (sp::opt<std::string>, inreplyto)
        (sp::opt<sp::Lids>, lids) )

BOOST_FUSION_ADAPT_STRUCT(sp::ComposeDraft,
        (sp::Attaches, attaches)
        (sp::Sender, sender)
        (sp::Message, message)
        (sp::Recipients, recipients)
        (sp::opt<sp::References>, references)
        (sp::opt<std::string>, inreplyto)
        (sp::opt<sp::Lids>, lids) )

BOOST_FUSION_ADAPT_STRUCT(sp::RemindMessageCallback,
        (sp::Mid, mid)
        (std::string, lang)
        (std::string, date)
        (std::string, account) )

BOOST_FUSION_ADAPT_STRUCT(sp::NoAnswerRemindCallback,
        (std::string, message_id)
        (std::string, lang)
        (std::string, date) )

BOOST_FUSION_ADAPT_STRUCT(sp::ListUnsubscribe,
        (std::string, to)
        (sp::opt<std::string>, subject)
        (sp::opt<std::string>, body)
        (sp::opt<sp::Mailbox>, from_mailbox) )

BOOST_FUSION_ADAPT_STRUCT(sp::PostProcessMessage,
    (std::string, nonempty_subject)
    (std::string, message_id)
    (std::time_t, message_date)
    (sp::Recipients, nonempty_recipients)
    (sp::opt<sp::Lids>, lids)
    (sp::opt<sp::Mid>, source_mid)
    (sp::opt<std::time_t>, noanswer_remind_period)
    (sp::opt<sp::InReplyTo>, inreplyto)
    (sp::opt<sp::Mids>, forward_mids)
)

BOOST_FUSION_ADAPT_STRUCT(sp::ContinueSendingMessage,
    (sp::opt<sp::Mentions>, mentions)
    (sp::PostProcessMessage, postprocess)
    (bool, notify_on_send)
)

BOOST_FUSION_ADAPT_STRUCT(sp::ContinueSendingMessageGetAdaptor,
    (sp::Mid, mid)
)

#define HEADER(TYPE, CONF_NAME, NAME) (CONF_NAME, TYPE, TYPE, obj.NAME, obj.NAME = val)
#define NONOPTIONAL(TYPE, NAME) (NAME, sp::opt<TYPE>, TYPE, obj.NAME, obj.NAME = val ? *val : "")

YREFLECTION_ADAPT_ADT(sp::CommonParams,
                      NONOPTIONAL(std::string, caller)
                      YREFLECTION_MEMBER(sp::Uid, uid)
                      )

YREFLECTION_ADAPT_ADT(sp::CommonParamsHeaderAdapter,
                      HEADER(std::string, X-Request-Id, requestId)
                      HEADER(std::string, X-Real-Ip, realIp)
                      HEADER(std::string, X-Original-Host, originalHost)
                      )

YREFLECTION_ADAPT_ADT(sp::UserJournalParams,
                      HEADER(std::string, connection_id, connectionId)
                      HEADER(std::string, X-Yandex-ExpBoxes, expBoxes)
                      HEADER(std::string, X-Yandex-EnabledExpBoxes, enabledExpBoxes)
                      HEADER(std::string, X-Yandex-ClientType, clientType)
                      HEADER(std::string, X-Yandex-ClientVersion, clientVersion)
                      HEADER(std::string, yandexuid, yandexUid)
                      HEADER(std::string, icookie, iCookie)
                      HEADER(std::string, User-Agent, userAgent) )

#undef NONOPTIONAL
#undef HEADER
