#pragma once

#include <mail/sendbernar/client/include/request.h>
#include <mail/sendbernar/client/include/internal/params_reflection.h>
#include <yamail/data/deserialization/urlencoded_reader.h>


namespace sendbernar::params {

template<class T>
auto get(const Request& req) {
    namespace ydd = yamail::data::deserialization;
    namespace yddu = yamail::data::deserialization::urlencoded;

    const auto oneArg = [&req](const std::string& name) {
        return req.optionalArg(name);
    };

    const auto oneHeader = [&req](const std::string& name) -> boost::optional<std::string> {
        return req.optionalHeader(name).get_value_or("");
    };

    const auto manyArgs = [&req](const std::string& name) {
        return req.optionalArgs(name);
    };

    try {
        T retval;

        if constexpr (std::is_same_v<T, sp::CommonParams>) {
            CommonParamsHeaderAdapter adapted(retval);

            ydd::fromUrlencoded(retval, oneArg);
            ydd::fromUrlencoded(adapted, oneHeader);
        } else if constexpr (std::is_same_v<T, sp::UserJournalParams>) {
            ydd::fromUrlencoded(retval, oneHeader);
        } else if constexpr (std::is_same_v<T, sp::ContinueSendingMessage>) {
            ContinueSendingMessageGetAdaptor adapted(retval);

            ydd::fromUrlencoded(retval, oneArg, manyArgs);
            ydd::fromUrlencoded(adapted, oneArg, manyArgs);
        } else if constexpr (std::is_same_v<T, sp::WriteAttachParams>) {
            const auto filename = req.optionalArg("filename");
            if (!filename) {
                throw NoSuchEntry("filename");
            }

            retval.filename = *filename;
            retval.raw_body = req.rawBody();
        } else {
            ydd::fromUrlencoded(retval, oneArg, manyArgs);
        }

        return retval;
    } catch(const Exception&) {
        throw;
    } catch (const yddu::NoSuchEntry& ex) {
        throw NoSuchEntry(ex.what());
    } catch (const yddu::BadCast& ex) {
        throw BadCast(ex.what());
    } catch (const yddu::ReaderException& ex) {
        throw ReaderException(ex.what());
    } catch(const std::exception& ex) {
        throw ReaderException(ex.what());
    }
}

}
