#pragma once

#include <yamail/data/reflection.h>
#include <mail/sendbernar/client/include/result.h>
#include <boost/fusion/adapted/struct.hpp>
#include <butil/butil.h>

namespace {
template<class T>
inline boost::optional<T> valOrNone(const std::string& cond, const T& val) {
    return boost::make_optional(!cond.empty(), val);
}
}

BOOST_FUSION_ADAPT_STRUCT(sendbernar::LimitResult,
                          (std::string, login)
                          (std::string, domain)
                          (unsigned long long, limit)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::Stored,
                          (std::string, mid)
                          (std::string, fid)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::CaptchaResult,
                          (std::string, key)
                          (std::string, url)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::DelayedMessageCallbackResponse,
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::RemindMessageCallbackResponse,
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::SendBarbetMessageResponse,
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::NoAnswerRemindCallbackResponse,
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::ListUnsubscribeResponse,
                          (std::string, messageId)
                          )


BOOST_FUSION_ADAPT_STRUCT(sendbernar::WriteAttachmentResponse,
                          (std::string, id)
                          (std::string, hash)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::CancelSendDelayedResponse,
                          (bool, allDone)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::MessageSentResponse,
                          (std::string, messageId)
                          (sendbernar::LimitedResult, limited)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::ComposeDraftResult,
                          (sendbernar::AttachmentsResult, attachments)
                          (std::string, text)
                          (std::string, from)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::LimitsResponse::DomainLimit,
                          (std::string, domain)
                          (std::optional<int>, size)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::LimitsResponse::Domains,
                          (std::vector<sendbernar::LimitsResponse::DomainLimit>, limits)
                          (bool, maxRecipientsReached)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::LimitsResponse::Config,
                          (std::size_t, attachmentsMaxSize)
                          (std::size_t, messageMaxSize)
                          (std::size_t, maxRecipients)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::LimitsResponse,
                          (std::optional<sendbernar::LimitsResponse::Domains>, domains)
                          (sendbernar::LimitsResponse::Config, config)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::MessageSavedResponse,
                          (sendbernar::Stored, stored)
                          (sendbernar::AttachmentsResult, attachments)
                          (sendbernar::LimitedResult, limited)
                          (std::string, messageId)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::MessageSentCacheResponse,
                          (std::string, messageId)
                          )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::GenerateOperationIdResponse,
                          (std::string, id)
                          )

#define TRANSFORM(TYPE, NAME, GETTER, SETTER) (NAME, TYPE, TYPE, GETTER, SETTER)
#define TRANSFORM_RO(TYPE, NAME, GETTER) (NAME, TYPE, TYPE, GETTER, {(void)obj; (void)val; throw std::logic_error(std::string("There are no setter with name ")+#NAME);})
#define MEMBER(TYPE, NAME) TRANSFORM(TYPE, NAME, obj.NAME, obj.NAME=val)

YREFLECTION_ADAPT_ADT(sendbernar::ComposeMessageResult,
                      MEMBER(std::string, text)
                      MEMBER(std::vector<std::string>, to)
                      MEMBER(std::vector<std::string>, cc)
                      MEMBER(std::vector<std::string>, bcc)
                      MEMBER(std::string, from)
                      )

YREFLECTION_ADAPT_ADT(sendbernar::AttachmentResult,
                      TRANSFORM_RO(std::string, name_uri_encoded, encode_url(obj.name))
                      TRANSFORM_RO(std::string, subtype, obj.subType)
                      YREFLECTION_ROMEMBER(std::string, type)
                      YREFLECTION_ROMEMBER(std::string, name)
                      YREFLECTION_ROMEMBER(std::string, clas)
                      YREFLECTION_ROMEMBER(std::string, hid)
                      YREFLECTION_ROMEMBER(size_t, length)
                      TRANSFORM_RO(boost::optional<std::string>, old_hid,
                                valOrNone(obj.oldHid, obj.oldHid))
                      TRANSFORM_RO(boost::optional<std::string>, att_id,
                                valOrNone(obj.attId, obj.attId))
                      YREFLECTION_ROMEMBER(std::string, hash)
                      )

#undef MEMBER
#undef TRANSFORM_RO
#undef TRANSFORM

BOOST_FUSION_ADAPT_STRUCT(sendbernar::error::Response,
        (std::string, category)
        (std::string, message)
        (std::string, reason) )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::error::LimitedResponse,
        (std::string, category)
        (std::string, message)
        (std::string, reason)
        (std::string, messageId) )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::error::SpamOrVirusWasFound,
        (std::string, category)
        (std::string, message)
        (std::string, reason)
        (std::optional<std::string>, banReason)
        (std::string, messageId)
        (sendbernar::Stored, stored) )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::error::CaptchaRequested,
        (std::string, category)
        (std::string, message)
        (std::string, reason)
        (std::string, messageId)
        (sendbernar::CaptchaResult, captcha)
        (sendbernar::Stored, stored) )

BOOST_FUSION_ADAPT_STRUCT(sendbernar::MessageWithErrorOnSharing,
        result
)
