#pragma once

#include <mail/sendbernar/client/include/internal/params_reflection.h>
#include <mail/sendbernar/client/include/params_to_request.h>
#include <yamail/data/serialization/urlencoded_writer.h>


namespace sendbernar::request {

template<class Param>
inline void write(Request& req, Param& params) {
    namespace yds = yamail::data::serialization;

    const auto header = [&req](const std::string& name, const std::string& val) {
        req.headers.add(name, val);
    };

    const auto getArg = [&req](const std::string& name, const std::string& val) {
        req.getArgs.add(name, val);
    };

    const auto postArg = [&req](const std::string& name, const std::string& val) {
        req.postArgs.add(name, val);
    };

    if constexpr (std::is_same_v<Param, params::UserJournalParams>) {
        yds::toUrlencoded(params, header);
    } else if constexpr (std::is_same_v<Param, params::CommonParams>) {
        params::CommonParamsHeaderAdapter adapter(params);

        yds::toUrlencoded(params, getArg);
        yds::toUrlencoded(adapter, header);
    } else if constexpr (std::is_same_v<Param, params::ContinueSendingMessage>) {
        params::ContinueSendingMessageGetAdaptor adaptor(params);

        yds::toUrlencoded(params, postArg);
        yds::toUrlencoded(adaptor, getArg);
    } else if constexpr (std::is_same_v<Param, params::RemindMessageCallback> ||
                         std::is_same_v<Param, params::NoAnswerRemindCallback>) {
        yds::toUrlencoded(params, getArg);
    } else {
        yds::toUrlencoded(params, postArg);
    }
}

}
