#pragma once

#include <mail/sendbernar/client/include/delivery_result.h>
#include <mail/http_getter/client/include/request_status.h>

namespace sendbernar::metrics {

struct SmtpGate {
    DeliveryResult result = DeliveryResult::ok;
};

struct ErrorCode {
    std::string category;
    int value = 0;
    std::string message;
};

struct ServiceRequest {
    struct HttpCall {
        unsigned code = 0;
        bool exception = false;
        double duration = 0.0;

        explicit HttpCall()
            : code(0)
            , exception(false)
            , duration(0.0)
        { }

        explicit HttpCall(unsigned c, double elapsed)
            : code(c)
            , exception(false)
            , duration(elapsed)
        { }

        explicit HttpCall(double elapsed)
            : code(0)
            , exception(true)
            , duration(elapsed)
        { }
    };

    std::string operation;
    http_getter::RequestStatus status = http_getter::RequestStatus::success;
    std::vector<HttpCall> calls;
};

}
