#pragma once

#include <mail/sendbernar/client/include/exception.h>
#include <mail/sendbernar/client/include/params.h>
#include <ymod_webserver/response.h>
#include <boost/optional.hpp>
#include <spdlog/details/format.h>


namespace sendbernar {

struct ReaderException: public Exception {
    using Exception::Exception;
};

struct NoSuchEntry: public ReaderException {
    NoSuchEntry(std::string_view name)
        : ReaderException(fmt::format("No such entry: {}", name))
    { }
};

struct BadCast: public ReaderException {
    BadCast(std::string_view name, std::string_view value)
        : ReaderException(fmt::format("Bad cast of {} with value {}", name, value))
    { }

    BadCast(const std::string& name)
        : ReaderException(name)
    { }
};

struct Request {
    virtual ~Request() { }

    virtual boost::optional<std::vector<std::string>> optionalArgs(const std::string& name) const = 0;
    virtual boost::optional<std::string> optionalArg(const std::string& name) const = 0;
    virtual boost::optional<std::string> optionalHeader(const std::string& name) const = 0;
    virtual std::string rawBody() const = 0;
};

params::SaveTemplate getSaveTemplate(const Request& req);
params::SaveDraft getSaveDraft(const Request& req);
params::SendMessage getSendMessage(const Request& req);
params::ListUnsubscribe getListUnsubscribe(const Request& req);
params::SendDelayed getSendDelayed(const Request& req, bool relative);
params::CancelSendDelayed getCancelSendDelayed(const Request& req);
params::ComposeMessage getComposeMessage(const Request& req);
params::ComposeDraft getComposeDraft(const Request& req);
params::RemindMessageCallback getRemindMessageCallback(const Request& req);
params::NoAnswerRemindCallback getNoAnswerRemindCallback(const Request& req);
params::LimitsParams getLimitsParams(const Request& req);
params::WriteAttachParams getWriteAttachParams(const Request& req);
params::CommonParams getCommonParams(const Request& req, const std::string& remoteAddress);
params::UserJournalParams getUserJournalParams(const Request& req);
params::ContinueSendingMessage getContinueSendingMessage(const Request& req);
params::SendBarbetMessage getSendBarbetMessage(const Request& req);
params::SendShare getSendShare(const Request& req);

}
