#pragma once

#include <mail/sendbernar/client/include/result.h>
#include <mail/sendbernar/client/include/error_result.h>
#include <mail/sendbernar/client/include/delivery_result.h>
#include <mail/sendbernar/client/include/response_status.h>
#include <ymod_webserver/codes.h>
#include <butil/http/headers.h>


namespace sendbernar::response {

struct SaveMessageWithOptionalCaptcha {
    DeliveryResult result;
    CaptchaResult captcha;
    MessageSavedResponse response;
    std::optional<std::string> banReason;
};

struct Response {
    explicit Response(const std::string& data);
    explicit Response(const DelayedMessageCallbackResponse& data);
    explicit Response(const CallbackResponseError& data);
    explicit Response(const RemindMessageCallbackResponse& data);
    explicit Response(const NoAnswerRemindCallbackResponse& data);
    explicit Response(const WriteAttachmentResponse& data);
    explicit Response(const CancelSendDelayedResponse& data);
    explicit Response(const ListUnsubscribeResponse& data);
    explicit Response(const GenerateOperationIdResponse& data);
    explicit Response(const MessageSentCacheResponse& data);
    explicit Response(const SendBarbetMessageResponse& data);
    explicit Response(const MessageWithErrorOnSharing& data);

    explicit Response(mail_errors::error_code ec);

    explicit Response(mail_errors::error_code status, const std::string& messageId);
    explicit Response(const SaveMessageWithOptionalCaptcha& data);
    explicit Response(MessageSavedResponse response);
    explicit Response(MessageSentResponse response);
    explicit Response(LimitsResponse response);
    explicit Response(const ComposeDraftResult& response);
    explicit Response(const ComposeMessageResult& response);

    ymod_webserver::codes::code code;
    std::string body;
    std::pair<std::string, std::string> contentType;
    mail_errors::error_code errorCode;
    http::headers additionalHeaders;

private:
    template<class T>
    void initJson(ResponseStatus code, const T& data);
};

}
