#pragma once

#include <macs/types.h>
#include <boost/optional.hpp>
#include <butil/email/email.h>
#include <mail/sendbernar/client/include/params.h>
#include <mail/sendbernar/client/include/delivery_result.h>


namespace sendbernar {

struct LimitResult {
    std::string login;
    std::string domain;
    unsigned long long limit;
};
using LimitedResult = std::vector<LimitResult>;

struct CaptchaResult {
    std::string url;
    std::string key;
};

struct AttachmentResult {
    std::string hid;
    std::string oldHid;
    std::string type;
    std::string subType;
    std::string name;
    std::string clas;
    size_t length = 0;
    std::string attId;
    std::string hash;
};
using AttachmentsResult = std::vector<AttachmentResult>;

struct Stored {
    std::string mid;
    std::string fid;
};

struct ComposeMessageResult {
    std::string text;
    std::vector<std::string> to;
    std::vector<std::string> cc;
    std::vector<std::string> bcc;
    std::string from;
};

struct ComposeDraftResult {
    std::string text;
    AttachmentsResult attachments;
    std::string from;
};

struct MessageSavedResponse {
    std::string messageId;
    Stored stored;
    LimitedResult limited;
    AttachmentsResult attachments;
};

struct MessageSentResponse {
    std::string messageId;
    LimitedResult limited;
};

struct MessageSentCacheResponse {
    std::string messageId;
};

struct SendBarbetMessageResponse
{ };

struct DelayedMessageCallbackResponse
{ };

struct CallbackResponseError {
    bool stopTrying = false;
};

struct RemindMessageCallbackResponse
{ };

struct NoAnswerRemindCallbackResponse
{ };

struct ListUnsubscribeResponse {
    std::string messageId;
};

struct WriteAttachmentResponse {
    std::string id;
    std::string hash;
};

struct LimitsResponse {
    struct DomainLimit {
        std::string domain;
        std::optional<int> size;
    };

    struct Domains {
        bool maxRecipientsReached = false;
        std::vector<DomainLimit> limits;
    };

    struct Config {
        std::size_t attachmentsMaxSize = 0;
        std::size_t messageMaxSize = 0;
        std::size_t maxRecipients = 0;
    };

    Config config;
    std::optional<Domains> domains;
};

struct CancelSendDelayedResponse {
    bool allDone = false;
};

struct GenerateOperationIdResponse {
    std::string id;
};

struct MessageWithErrorOnSharing {
    DeliveryResult result;
};

namespace error {

struct Response {
    std::string category;
    std::string message;
    std::string reason;
};

struct LimitedResponse {
    std::string category;
    std::string message;
    std::string reason;

    std::string messageId;
};

struct SpamOrVirusWasFound {
    std::string category;
    std::string message;
    std::string reason;
    std::optional<std::string> banReason;

    std::string messageId;
    Stored stored;
};

struct CaptchaRequested {
    std::string category;
    std::string message;
    std::string reason;

    std::string messageId;
    CaptchaResult captcha;
    Stored stored;
};

}
}
