'use strict';

module.exports = {
    root: true,

    env: {
        es6: true,
        node: true
    },

    plugins: [
        'node',
        'security'
    ],

    extends: [
        'eslint:recommended',
        'yandex-personal/es6',
        'plugin:node/recommended'
    ],

    rules: {
        'keyword-spacing': [ 'error', { before: true, after: true } ],

        // plugins
        'node/exports-style': [ 'error', 'module.exports' ],
        'security/detect-buffer-noassert': [ 'error' ],
        'security/detect-pseudoRandomBytes': [ 'error' ],

        // warnings
        'no-warning-comments': [ 'warn', { location: 'anywhere' } ],

        // off
        'node/shebang': 'off',
        'node/no-unpublished-require': 'off',
        'node/no-extraneous-require': 'off',
        'prefer-arrow-callback': 'off',
        'padded-blocks': 'off',
        'prefer-spread': 'off',
        'prefer-rest-params': 'off',
        'no-eq-null': 'off',
        'object-shorthand': 'off',
        'camelcase': 'off'
    }
};

const testConfig = {
    files: [ 'test/**', '**/*.spec.js', '!test/integration/**' ],

    env: {
        mocha: true
    },

    plugins: [ 'mocha' ],

    rules: {
        'mocha/no-exclusive-tests': [ 'error' ],
        'mocha/no-global-tests': [ 'error' ],
        'mocha/no-identical-title': [ 'error' ],
        'mocha/no-sibling-hooks': [ 'error' ],
        'no-invalid-this': 'off',
        'no-unused-expressions': 'off'
    },

    globals: {
        expect: false,
        should: false,
        sinon: false
    }
};

module.exports.overrides = [ testConfig ];