#include <mail/sendbernar/client/include/category.h>


namespace sendbernar {

std::string specialNameForBadRecipient() {
    return "incorrect_to";
}

std::string SendbernarCategory::message(int v) const {
    switch(ErrorResult(v)) {
        case ErrorResult::ok:
            return "no error";
        case ErrorResult::invalidParam:
            return "invalid param";
        case ErrorResult::bbError:
            return "bb error";
        case ErrorResult::unexpectedCondition:
            return "unexpected condition";
        case ErrorResult::reminderError:
            return "reminder exception";
        case ErrorResult::storageError:
            return "storage error";
        case ErrorResult::wrongHttpMethod:
            return "wrong http method";
        case ErrorResult::cannotSaveMessage:
            return "cannot save message";
        case ErrorResult::fromCache:
            return "message with such operation_id is already processed";
    }
    return "unknown enum code";
}

std::string NwCategory::message(int v) const {
    switch(DeliveryResult(v)) {
        case DeliveryResult::ok:
            return "ok";
        case DeliveryResult::spam:
            return "captcha requested";
        case DeliveryResult::unknownError:
            return "unknown error";
        case DeliveryResult::badRequest:
            return "bad request";
        case DeliveryResult::badKarmaBanTime:
            return "bad karma";
        case DeliveryResult::sendMessageFailed:
            return "send message failed";
        case DeliveryResult::serviceUnavaliable:
            return "service unavaliable";
        case DeliveryResult::failedToAuthSender:
            return "failed to auth sender";
        case DeliveryResult::badSender:
            return "bad sender";
        case DeliveryResult::toManyRecipients:
            return "too many recipients";
        case DeliveryResult::sizeLimitExceeded:
            return "size limit exceeded";

        // special cases for js client
        case DeliveryResult::strongSpam:
            return "strongspam_found";
        case DeliveryResult::virus:
            return "virus_found";
        case DeliveryResult::badRecipient:
            return specialNameForBadRecipient();
    }
    return "unknown enum code";
}

std::string ComposeCategory::message(int v) const {
    switch(ComposeResult(v)) {
        case ComposeResult::EMPTY:
            return "empty";
        case ComposeResult::DONE:
            return "done";
        case ComposeResult::MSG_TOO_BIG:
            return "message too big";
        case ComposeResult::CHARSET_INVALID:
            return "charset invalid";
        case ComposeResult::ATTACHMENT_STORAGE_ERROR:
            return "attachment storage error";
        case ComposeResult::PARTS_JSON_INVALID:
            return "parts json invalid";
        case ComposeResult::SANITIZER_CALL_WAS_NOT_SUCCESS:
            return "sanitizer call was not success";

        // special cases for js client
        case ComposeResult::TO_INVALID:
            return specialNameForBadRecipient();
        case ComposeResult::CC_INVALID:
            return "incorrect_cc";
        case ComposeResult::BCC_INVALID:
            return "incorrect_bcc";
        case ComposeResult::TO_CC_BCC_EMPTY:
            return "no_recipients";
        case ComposeResult::ATTACHMENT_TOO_BIG:
            return "attachment_too_big";
        case ComposeResult::MAX_EMAIL_ADDR_REACHED:
            return "max_email_addr_reached";
    }
    return "unknown enum code";
}

ResponseStatus toResponseStatus(ErrorResult code) {
    switch(code) {
        case ErrorResult::ok:
            return ResponseStatus::ok;

        case ErrorResult::invalidParam:
        case ErrorResult::bbError:
            return ResponseStatus::badRequest;

        case ErrorResult::unexpectedCondition:
        case ErrorResult::reminderError:
        case ErrorResult::storageError:
            return ResponseStatus::internalError;

        case ErrorResult::wrongHttpMethod:
            return ResponseStatus::wrongMethod;

        case ErrorResult::cannotSaveMessage:
            return ResponseStatus::cannotSaveMessage;

        case ErrorResult::fromCache:
            return ResponseStatus::fromCache;
    }
    return ResponseStatus::internalError;
}

ResponseStatus toResponseStatus(DeliveryResult code) {
    switch(code) {
        case DeliveryResult::ok:
            return ResponseStatus::ok;

        case DeliveryResult::spam:
            return ResponseStatus::captchaRequested;

        case DeliveryResult::strongSpam:
        case DeliveryResult::virus:
            return ResponseStatus::spamOrVirusWasFound;

        case DeliveryResult::badRecipient:
        case DeliveryResult::badKarmaBanTime:
        case DeliveryResult::failedToAuthSender:
        case DeliveryResult::badSender:
        case DeliveryResult::toManyRecipients:
        case DeliveryResult::sizeLimitExceeded:
        case DeliveryResult::badRequest:
            return ResponseStatus::badRequest;

        case DeliveryResult::unknownError:
        case DeliveryResult::sendMessageFailed:
        case DeliveryResult::serviceUnavaliable:
            return ResponseStatus::internalError;
    }
}

ResponseStatus toResponseStatus(ComposeResult code) {
    switch(code) {
        case ComposeResult::DONE:
            return ResponseStatus::ok;

        case ComposeResult::TO_INVALID:
        case ComposeResult::CC_INVALID:
        case ComposeResult::BCC_INVALID:
        case ComposeResult::TO_CC_BCC_EMPTY:
        case ComposeResult::MAX_EMAIL_ADDR_REACHED:
        case ComposeResult::ATTACHMENT_TOO_BIG:
        case ComposeResult::CHARSET_INVALID:
        case ComposeResult::ATTACHMENT_STORAGE_ERROR:
        case ComposeResult::PARTS_JSON_INVALID:
                return ResponseStatus::badRequest;

        case ComposeResult::MSG_TOO_BIG:
            return ResponseStatus::limited;

        case ComposeResult::EMPTY:
        case ComposeResult::SANITIZER_CALL_WAS_NOT_SUCCESS:
            return ResponseStatus::internalError;
    }
}

const SendbernarCategory& getSendbernarCategory() {
    static SendbernarCategory instance;
    return instance;
}


const NwCategory& getNwCategory() {
    static NwCategory instance;
    return instance;
}

const ComposeCategory& getComposeCategory() {
    static ComposeCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(DeliveryResult e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getNwCategory());
}

mail_errors::error_code::base_type make_error_code(ErrorResult e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getSendbernarCategory());
}

mail_errors::error_code::base_type make_error_code(ComposeResult e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getComposeCategory());
}

mail_errors::error_code make_error(ErrorResult e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

mail_errors::error_code make_error(DeliveryResult e) {
    return mail_errors::error_code(e);
}

mail_errors::error_code make_error(ComposeResult e) {
    return mail_errors::error_code(e);
}

}
