#include <mail/sendbernar/client/include/params.h>
#include <yamail/data/deserialization/json_reader.h>
#include <yamail/data/serialization/json_writer.h>
 
namespace sendbernar::params {
 
std::istream& operator>>(std::istream& in, IdetifiableMessagePart& p) {
    std::string json;
    std::getline(in, json);
    p = yamail::data::deserialization::fromJson<IdetifiableMessagePart>(json);
 
    return in;
}
 
std::ostream& operator<<(std::ostream& out, const IdetifiableMessagePart& p) {
    out << yamail::data::serialization::JsonWriter<params::IdetifiableMessagePart>(p).result();
    return out;
}
 
std::istream& operator>>(std::istream& in, DiskAttach& p) {
    std::string json;
    std::getline(in, json);
    p = yamail::data::deserialization::fromJson<DiskAttach>(json);
 
    return in;
}
 
std::ostream& operator<<(std::ostream& out, const DiskAttach& p) {
    out << yamail::data::serialization::JsonWriter<params::DiskAttach>(p).result();
    return out;
}
 
}
 
namespace sp = sendbernar::params;
 
BOOST_FUSION_ADAPT_STRUCT(sp::IdetifiableMessagePart,
    (std::string, mid)
    (std::string, hid)
)
 
BOOST_FUSION_ADAPT_STRUCT(sp::DiskAttach,
    (std::string, path)
    (std::string, name)
    (sp::opt<std::string>, hash)
    (sp::opt<std::string>, preview_path)
    (sp::opt<std::size_t>, size)
    (sp::opt<std::string>, folder)
)

