#include <mail/sendbernar/client/include/internal/reader.h>
#include <butil/network/real_ip_from_headers.h>
#include <mail/sendbernar/client/include/internal/params_reflection.h>

namespace sendbernar {

#define DEFINE_GETTER(TYPE, NAME) TYPE NAME(const Request& req) { return params::get<TYPE>(req); }

DEFINE_GETTER(params::SaveTemplate, getSaveTemplate)
DEFINE_GETTER(params::SaveDraft, getSaveDraft)
DEFINE_GETTER(params::ListUnsubscribe, getListUnsubscribe)
DEFINE_GETTER(params::SendMessage, getSendMessage)
DEFINE_GETTER(params::SendShare, getSendShare)
DEFINE_GETTER(params::CancelSendDelayed, getCancelSendDelayed)
DEFINE_GETTER(params::ComposeMessage, getComposeMessage)
DEFINE_GETTER(params::ComposeDraft, getComposeDraft)
DEFINE_GETTER(params::ContinueSendingMessage, getContinueSendingMessage)
DEFINE_GETTER(params::RemindMessageCallback, getRemindMessageCallback)
DEFINE_GETTER(params::NoAnswerRemindCallback, getNoAnswerRemindCallback)
DEFINE_GETTER(params::SendBarbetMessage, getSendBarbetMessage)
DEFINE_GETTER(params::WriteAttachParams, getWriteAttachParams)
DEFINE_GETTER(params::UserJournalParams, getUserJournalParams)
DEFINE_GETTER(params::LimitsParams, getLimitsParams)

params::CommonParams getCommonParams(const Request& req, const std::string& remoteAddress) {
    auto params = params::get<params::CommonParams>(req);

    params.realIp = real_ip::getFromHeaders(req.optionalHeader("X-Forwarded-For"),
                                            req.optionalHeader("X-Real-Ip"),
                                            remoteAddress);

    return params;
}

params::SendDelayed getSendDelayed(const Request& req, bool relative) {
    auto params = params::get<params::SendDelayed>(req);
    params.relative = relative;
    return params;
}


#undef DEFINE_GETTER

}
