#include <mail/sendbernar/client/include/params_to_request.h>
#include <mail/sendbernar/client/include/handler_url.h>
#include <mail/sendbernar/client/include/internal/writer.h>

namespace sendbernar {
namespace request {

template<class Req, class Params>
void fill(Req& req, params::CommonParams common, params::UserJournalParams uj, Params& params) {
    static const std::string clientArg = "sc";
    static const std::string apiVersion = "1";

    req.getArgs.add("v", apiVersion);
    req.getArgs.add(clientArg, "");
    write(req, common);
    write(req, uj);
    write(req, params);
}

Request callbackDelayedOrUndoMessage(params::CommonParams common, params::UserJournalParams uj,
                                     params::ContinueSendingMessage params, bool undo) {
    Request req;
    req.path = undo ? server::callbacks::sendUndoMessage()
                    : server::callbacks::sendDelayedMessage();
    fill(req, common, uj, params);
    req.headers.add("Content-Type", "application/x-www-form-urlencoded");

    return req;
}

Request callbackNoAnswer(params::CommonParams common, params::UserJournalParams uj,
                         params::NoAnswerRemindCallback params) {
    Request req;
    req.path = server::callbacks::noAnswerRemind();
    fill(req, common, uj, params);
    req.headers.add("Content-Type", "application/x-www-form-urlencoded");

    return req;
}

}
}
