#include <mail/sendbernar/composer/include/body_and_attaches.h>
#include <mail_getter/UTFizer.h>
#include <contrib/libs/fmt/include/fmt/format.h>

namespace sendbernar {

bool mustBeEncodedBase64(const std::string&);

void setBody(const std::string& body, const std::string& narodAttach, bool force7bit, bool isTextHtml, RfcMessage& sm) {
    ContentTypeEncoding cte = ContentTypeEncoding::SevenBit;
    if (have_8bit(body) || have_8bit(narodAttach)) {
        cte = force7bit ? ContentTypeEncoding::Base64 : ContentTypeEncoding::EightBit;
        sm.setUtf8();
    }
    if (mustBeEncodedBase64(body)) {
        cte = ContentTypeEncoding::Base64;
    }
    sm.addBody(body, cte, isTextHtml);
}

void BodyAndAttaches::setBody(const std::string& body, RfcMessage& sm) const {
    sendbernar::setBody(body, narodAttach_, force7bit_, isTextHtml_, sm);
}

void BodyAndAttaches::setNarodAttach(const std::string& body, RfcMessage& m) {
    ContentTypeEncoding cte = ContentTypeEncoding::SevenBit;
    UTFizer::process(recognizer_, "utf-8", narodAttach_);
    if (have_8bit(narodAttach_) && have_8bit(body)) {
        cte = force7bit_ ? ContentTypeEncoding::Base64 : ContentTypeEncoding::EightBit;
    }
    if (mustBeEncodedBase64(narodAttach_)) {
        cte = ContentTypeEncoding::Base64;
    }
    m.addNarodAttach(narodAttach_, cte);

    LOGDOG_(logger_, debug, log::has_narod_attaches=!narodAttach_.empty());
}

std::string BodyAndAttaches::attachesWithTitle(const std::string& attaches, const std::string& title) {
    return attaches.empty() ? "" : fmt::format("<b style=\"display:block;margin-top:1.33em;\">{} </b>{}", title, attaches);
}

CachedComposeResult BodyAndAttaches::processAttaches(MultipartRelaxedMessage& msg,
                                                     const RemoteAttachments& remoteAtts,
                                                     std::size_t& totalAttachmentSize) const {

    for (std::size_t i = 0; i < remoteAtts.size(); ++i) {
        const RemoteAttachment& att = remoteAtts[i];
        totalAttachmentSize += att.body.size();

        if (totalAttachmentSize > attachmentsMaxSize_) {
            return ComposeResult::ATTACHMENT_TOO_BIG;
        }

        MimeType mType = detector_.detectByContent(att.body);
        msg.addRemoteAttach(mType, att);
    }
    return ComposeResult::DONE;
}

CachedComposeResult BodyAndAttaches::apply(RfcMessage& m, const std::string& body, const RemoteAttachments& remoteAtts,
                                           std::size_t& totalAttachmentSize) {
    if (body.empty() && !remoteAtts.empty()) {
        throw std::runtime_error("body is empty, but there are inline attaches");
    }

    if (!body.empty()) {
        RfcMessagePtr sm = newMessage();

        setBody(body, *sm);

        if (!remoteAtts.empty()) {
            RfcMessagePtr pst = newMessage();
            MultipartRelaxedMessagePtr msg = pst->addRelatedPart(std::move(sm));

            if (auto res = processAttaches(*msg, remoteAtts,totalAttachmentSize); res != ComposeResult::DONE) {
                return res;
            }

            m.addPart(std::move(pst));
        } else {
            m.addPart(std::move(sm));
        }
    }

    if (!narodAttach_.empty()) {
        setNarodAttach(body, m);
    }

    return ComposeResult::DONE;
}

CachedComposeResult SimpleBody::apply(RfcMessage& m, const std::string& body) {
    setBody(body, "", force7bit_, isTextHtml_, m);

    return ComposeResult::DONE;
}

}
