#pragma once

#include <mail/sendbernar/composer/include/rfc_message.h>
#include <mail_getter/service.h>
#include <mail_getter/content_type.h>
#include <mail/sendbernar/core/include/composed_message.h>

namespace sendbernar {

struct AttachHelpers {
    const IContentTypeDetector& detector_;
    const Recognizer::Wrapper& recognizer_;
    const mail_getter::AttachmentStorage::VectorOfAttachments& storageAttachments_;
    std::vector<macs::Stid> idsList_;

    AttachHelpers(const IContentTypeDetector& detector,
                  const Recognizer::Wrapper& recognizer,
                  const mail_getter::AttachmentStorage::VectorOfAttachments& storageAttachments,
                  const std::vector<macs::Stid>& idsList)
        : detector_(detector)
        , recognizer_(recognizer)
        , storageAttachments_(storageAttachments)
        , idsList_(idsList)
    { }

    virtual ~AttachHelpers() { }

    virtual std::tuple<MimeParser::Hid, std::string, std::string> addAttachmentToMessage(RfcMessage& msg,
                                                                                         std::string filename,
                                                                                         std::string contentType,
                                                                                         const std::string& body) const;

    std::vector<compose::Attachment> getStorageAttachments(RfcMessage& m);
};

bool mustBeEncodedBase64(const std::string& t);

std::string calcHashAttachment(const std::string& body, const std::string& name);

}
