#pragma once

#include <mail/sendbernar/core/include/cached_compose_result.h>
#include <mail/sendbernar/composer/include/rfc_message.h>
#include <mail/sendbernar/composer/include/inline_handlers.h>
#include <mail/sendbernar/core/include/disk_attach_builder.h>
#include <mail_getter/content_type.h>

namespace sendbernar {

void setBody(const std::string& body, const std::string& narodAttach, bool force7bit,
             bool isTextHtml, RfcMessage& sm);

class BodyAndAttaches {
    std::string narodAttach_;
    bool isTextHtml_ = false;
    bool force7bit_ = false;
    std::size_t attachmentsMaxSize_ = 0;
    std::string diskAttachesTitle_;
    const IContentTypeDetector& detector_;
    const Recognizer::Wrapper& recognizer_;
    ContextLogger logger_;
    
public:
    template<class Params>
    BodyAndAttaches(const Params& params, std::size_t attachmentsMaxSize, const std::string& diskAttachTitle, const IContentTypeDetector& detector,
                    const DiskAttachBuilder& diskAttaches, const Recognizer::Wrapper& recognizer, ContextLogger logger)
        : narodAttach_(params::normalize(params).attaches.disk_attaches.get_value_or(""))
        , isTextHtml_(params::normalize(params).message.html.get_value_or(false))
        , force7bit_(params::normalize(params).message.force7bit.get_value_or(false))
        , attachmentsMaxSize_(attachmentsMaxSize)
        , diskAttachesTitle_(diskAttachTitle)
        , detector_(detector)
        , recognizer_(recognizer)
        , logger_(std::move(logger))
    {
        if (params::normalize(params).attaches.disk_attaches_json) {
            narodAttach_ += diskAttaches.build(*params::normalize(params).attaches.disk_attaches_json);
        }
        
        narodAttach_ = attachesWithTitle(narodAttach_, diskAttachesTitle_);
    }

    BodyAndAttaches(const BodyAndAttaches&) = default;
    BodyAndAttaches(BodyAndAttaches&&) = default;

    virtual ~BodyAndAttaches() { }

    virtual RfcMessagePtr newMessage() const {
        return std::make_shared<RfcMessage>();
    }

    void setBody(const std::string& body, RfcMessage& sm) const;
    void setNarodAttach(const std::string& body, RfcMessage& m);

    static std::string attachesWithTitle(const std::string& attaches, const std::string& title);

    CachedComposeResult processAttaches(MultipartRelaxedMessage& msg, const RemoteAttachments& remoteAtts,
                                        std::size_t& totalAttachmentSize) const;

    CachedComposeResult apply(RfcMessage& m, const std::string& body, const RemoteAttachments& remoteAtts,
                              std::size_t& totalAttachmentSize);

    const std::string& narodAttach() const {
        return narodAttach_;
    }
};

class SimpleBody {
    bool isTextHtml_ = false;
    bool force7bit_ = false;

public:
    template<class Params>
    SimpleBody(const Params& params)
        : isTextHtml_(params::normalize(params).message.html.get_value_or(false))
        , force7bit_(params::normalize(params).message.force7bit.get_value_or(false))
    { }

    CachedComposeResult apply(RfcMessage& m, const std::string& body);
};

}
