#pragma once

#include <mail/sendbernar/client/include/params.h>
#include <mail/sendbernar/core/include/http.h>
#include <mail/sendbernar/core/include/metadata.h>
#include <mail/sendbernar/core/include/logger.h>
#include <macs/envelope.h>
#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/core/include/recipients_repository.h>
#include <mail/sendbernar/core/include/composed_message.h>

namespace sendbernar {

class DelayedMessageComposer {
    std::string requestId;
    ContextLogger logger_;
    macs::Envelope envelope_;
    RecipientsRepository recipients_;
    std::vector<macs::LabelId> lids_;
    std::string authDomain_;

public:
    DelayedMessageComposer(const params::CommonParams& params, ContextLogger logger);

    struct ContinueSendingDelayedMessage { };
    using NeedToSend = boost::variant<ContinueSendingDelayedMessage, DelayedMessageCallbackResponse, mail_errors::error_code>;

    NeedToSend needToSend(const macs::Mid& mid, MetadataPtr m);

    compose::SendMessage message(const Account& a, const macs::Mid& mid,
                                 MetadataPtr m, SendConfigurationPtr cfg);

    RecipientsRepository& recipients() {
        return recipients_;
    }

    const std::vector<macs::LabelId>& lids() const {
        return lids_;
    }
};

}
