#pragma once

#include <string>
#include <mail/sendbernar/client/include/result.h>
#include <mail/sendbernar/client/include/delivery_result.h>


namespace sendbernar {

inline bool isSpamOrVirus(DeliveryResult result) {
    return result == DeliveryResult::virus ||
           result == DeliveryResult::spam ||
           result == DeliveryResult::strongSpam;
}

inline bool checkCaptcha(DeliveryResult result) {
    return result == DeliveryResult::spam;
}

inline bool needToSaveAsDraft(DeliveryResult result) {
    switch(result) {
        case DeliveryResult::spam:
        case DeliveryResult::strongSpam:
        case DeliveryResult::virus:
        case DeliveryResult::unknownError:
        case DeliveryResult::sendMessageFailed:
        case DeliveryResult::serviceUnavaliable:
        case DeliveryResult::badSender:
        case DeliveryResult::toManyRecipients:
        case DeliveryResult::sizeLimitExceeded:
            return true;

        case DeliveryResult::ok:
        case DeliveryResult::badRecipient:
        case DeliveryResult::badRequest:
        case DeliveryResult::badKarmaBanTime:
        case DeliveryResult::failedToAuthSender:
            return false;
    }
}

}
