#pragma once

#include <mail/sendbernar/composer/include/body_and_attaches.h>
#include <mail/sendbernar/client/include/params.h>

namespace sendbernar {

class HasAttaches {
    bool mids_;
    bool stids_;
    bool partsJson_;
    bool narod_;

public:
    template<class Params, class WithNarodAttach>
    HasAttaches(const Params& p, const WithNarodAttach& withNarodAttach)
        : mids_(params::normalize(p).attaches.forward_mids &&
                !params::normalize(p).attaches.forward_mids->empty())
        , stids_(params::normalize(p).attaches.uploaded_attach_stids &&
                 !params::normalize(p).attaches.uploaded_attach_stids->empty())
        , partsJson_(params::normalize(p).attaches.parts_json &&
                     !params::normalize(p).attaches.parts_json->empty())
        , narod_(!withNarodAttach.narodAttach().empty())
    { }

    bool hasAttaches(const RemoteAttachments& remote) const {
        return mids_ || stids_ || partsJson_ || narod_ || !remote.empty();
    }

    HasAttaches(const HasAttaches&) = default;
    HasAttaches(HasAttaches&&) = default;
};

}
